#!/usr/bin/php
<?php
/**
 * PHP NAGIOS check uptime over snmp (linux/windows) 
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20220328';

$arg=1;
$debug=false;
$debug_snmp=false;

$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';
$no_version=false;

$data='';


function fct_uptime($uptime){
$sec =  $uptime / 100              % 60;
$min = ($uptime / (100*60)       ) % 60;
$hours   = ($uptime / (100*60*60)   ) % 24;
$days    =  $uptime / (100*60*60*24);
  return floor($days) . ' days, ' . $hours . ' hours, ' . $min . ' minutes, ' . $sec  . ' seconds';
}


function get_snmp($snmp_oid_get) {
    global $disk, $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp ,$snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get, 1000000,5 );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get, 1000000,5 );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get, 1000000,5 );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get, 1000000,5 );
        }
     }
    if ( $snmp === false ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2);
    } 
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}

function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}


while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-n':
			$no_version=true;
			$arg=$arg - 1;
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
	}
	$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_uptime.php -H [home] -P [snmp_version] ( -n (no version) -d (debug) -V (snmp debug))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto. (DES/AES)] -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}

$snmp_oid='.1.3.6.1.2.1.25.1.1.0';

if ( $debug_snmp == true ) { 
    $snmp_oid_get=$snmp_oid;
    print_r(get_snmp($snmp_oid_get));
    $snmp_oid_get='1.3.6.1.2.1.1.1.0';
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}

$uptime=preg_split('/ /' , get_snmp($snmp_oid));
$uptime=fct_uptime(preg_replace("/[^0-9\.]/", "",$uptime[1]));
$version=preg_split('/ /', get_string('1.3.6.1.2.1.1.1.0'));
if ( $version[0] == 'Linux' and $no_version === false ) {
   echo 'OK - ' . $version[2] . ' - ' . $uptime . PHP_EOL; }
elseif ( $version[11] == 'Software:'and $no_version === false  ) {
   #echo 'OK - ' . $version[12] . ' ' . $version[13] . ' ' . $version[14] . ' ' . $version[15] . ' ' . $version[16]  . ') - ' . $uptime . PHP_EOL; }
   echo 'OK - ' . $version[15] . ' ' . $version[16]  . ') - ' . $uptime . PHP_EOL; }
elseif ( $no_versoin === false ) {
   echo 'OK - ' . $version[11]  . $uptime . PHP_EOL; }
else {
   echo 'OK - ' . $uptime . PHP_EOL; }
exit(0);



?>
