#!/usr/bin/php
<?php
/**
 * PHP NAGIOS check Synology NAS over snmp
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

/* 
   chagend mode -v to -d =debug 
   canged mode raid, add name
*/

$version='1.20220329';


$synology_system=array('cifs', 'afp', 'nfs', 'ftp', 'sftp', 'http/https', 'telnet', 'ssh, other');
$synology_updatestatus=array('Available', 'Unavailable', 'Connecting', 'Disconnected', 'Others');
$synology_diskstatus=array('Normal', 'Initialized', 'NotInitialized', 'SystemPartitionFailed', 'Crashed');
$synology_raidstatus=array('Normal', 'Repairing', 'Migrating', 'Expanding', 'Deleting', 'Creating', 'RaidSyncing', 'RaidParityChecking', 'RaidAssembling', 'Caneling', 'Degrade', 'Crashed', 'DataScrubbing', 'RaidDeploying', 'RaidMountCache', 'RaidUnMountCache', 'RaidExpandingUnfinishedSHR', 'RaidConvertSHRToPool', 'RaidConvertSHRToPool', 'RaidUnknownStatus');
$synology_mode=array('uptime', 'network','memory', 'cpu', 'system','disk','raid','ups', 'disksmart', 'service', 'io', 'spaceio', 'flashcache', 'iscsilun', 'ebox', 'ha', 'gpuinfo' , 'test');
$synology_test=array('temperatur', 'update', 'status', 'usage');

$arg=1;
$debug=false;
$debug_snmp=false;

$mode='';
$warn=0;
$crit=0;
$number='1';
$num=false;
$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';

$data='';
$disk=0;


function get_state($art, $wert, $status) {
$numstate=0;
$erg='OK';

if ( $wert != "" ) {
      $len=strlen($wert);
      $pos_a=stripos($wert,'@');
      $pos_d=stripos($wert,':');
      $pos_n=stripos($wert,'~');

      if ( is_numeric($pos_a) and is_numeric($pos_d)   )
        { $numstate = 1; }
      elseif ( is_numeric($pos_n) )
        { $numstate = 5;  }
      elseif ( $pos_d == 0 and is_numeric($pos_d) )
        { $numstate = 2; }
      elseif ( $pos_d > 0)
        { $numstate = 4; }
      elseif ( $pos_d == $len )
        { $numstate = 3; }

switch ($numstate ) {
    case "1":
      $wert=str_replace("@","",$wert);
      $critical=explode(":",$wert);
      if ( intval($status) >= intval($critical[0])  and  intval($status) <= intval($critical[1]) )
        { $numstate=1 ; }
      else
        { $numstate=0; }
      break;

    case "4":

      $critical=explode(":",$wert);
      if (( intval($status) < intval($critical[0])) or (intval($status) > intval($critical[1])) )
        { $numstate=1 ; }
      else 
        { $state='OK';
          $numstate=0; }
      break;

    case "5":
      $wert=str_replace("~","",$wert);
      if ( intval($status) < intval($wert)  )
        { $numstate=1 ; }
      else 
        { $numstate=0; }
      break;

    default:
      if ( intval($status) > intval($wert) )
          { $numstate=1; }
        else
          { $numstate=0; }
      }
   
    if ( $art == "C" and $numstate == 1 )
       { $numstate = 2; 
         $erg = 'CRITICAL'; }
    elseif ( $art == "W" and $numstate == 1 )
       { $erg = 'WARNING'; }
    else { $erg = 'OK'; }
}       
    return array($numstate,$erg);

}


function fct_uptime($uptime){
$sec =  $uptime / 100              % 60;
$min = ($uptime / (100*60)       ) % 60;
$hours   = ($uptime / (100*60*60)   ) % 24;
$days    =  $uptime / (100*60*60*24);
  return floor($days) . ' days, ' . $hours . ' hours, ' . $min . ' minutes, ' . $sec  . ' seconds';
}


function get_snmp($snmp_oid_get) {
    global $disk, $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp ,$snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get,1000000,5 );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get );
        }
     }
    if ( $snmp === false && $disk <= 1 ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2);
    } 
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}


function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));       
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}

function get_status () {
       global $mode,$snmp_oid , $test, $key , $warn, $crit;
       if ($mode == "service" ) {
         $snmp_oid_get=$snmp_oid . ".1.1.3." . ($key + 1);
         $service=preg_split('/ /' , get_snmp($snmp_oid_get));
         $status_service=intval($service[1]);

         $state=get_state('C', $crit, $status_service);
         if ($state[0] == 0 ) {
             $state=get_state('W', $warn, $status_service);
         }

         echo $state[1] . " - " . strtoupper($test) . ": " . $status_service . PHP_EOL; }
         exit($state[0]);
}




while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-m':
			$mode=strtolower(@$argv[$arg+1]);
                        if ( false === array_search($mode, $synology_mode))
                          { echo 'Error: -m mode, no correct mode value! Please check help - /usr/bin/php check_synology.php -h' . PHP_EOL; 
                            exit(0); }
			break;
		case '-w':
			$warn=@$argv[$arg+1];
			break;
		case '-c':
			$crit=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
		case '-t':
			$test=strtolower(@$argv[$arg+1]);
			break;
		case '-n':
			$number=@$argv[$arg+1];
                        $num=true;
			break;
		case '-l':
			$data=strtolower(@$argv[$arg+1]);
			break;
	}
	$arg = $arg + 2;
}



if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_synology.php -H [Synology NAS] -P [snmp_version] -m [mode] (-n [number] -l [data] -t [test] -w [Warning] -c [Critical] -d (debug) -V (snmp debug))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto. (DES/AES)] -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo '        -m mode   - system' . PHP_EOL;
echo '                    memory' . PHP_EOL;
echo '                    cpu' . PHP_EOL;
echo '                    disk' . PHP_EOL;
echo '                    raid' . PHP_EOL;
echo '                    ups' . PHP_EOL;
echo '                    network' . PHP_EOL;
echo '                    service' . PHP_EOL;
echo '                    uptime' . PHP_EOL;
echo '                    disksmart (*) (info: https://kb.synology.com/de-de/DSM/tutorial/How_to_diagnose_drives_health_status_when_receiving_bad_sector_warning)' . PHP_EOL;
echo '                    io (only snmp debug)' . PHP_EOL;
echo '                    spaceio (only snmp debug)' . PHP_EOL;
echo '                    flashcache (only snmp debug)' . PHP_EOL;
echo '                    iscsilun (only snmp debug)' . PHP_EOL;
echo '                    ebox (only snmp debug)' . PHP_EOL;
echo '                    ha (only snmp debug)' . PHP_EOL;
echo '                    gpuinfo (only snmp debug)' . PHP_EOL;
echo PHP_EOL;
echo '                    (*) - disksmart is warning if smart id 5' . PHP_EOL; 
echo '                          is greater or equal warning parameter ' . PHP_EOL;
echo '                          or critical it is greater or equal critical parameter ' . PHP_EOL;
echo '                        - warning if smart id 1 is greater 0 (only Samsung and WD) ' . PHP_EOL;
echo '                        - warning if smart id 5 and 197 and 198 are greater 0 ' . PHP_EOL;
echo PHP_EOL;
echo '        -n number - disk/raid/network'  . PHP_EOL;
echo PHP_EOL;
echo '        -t test   - temperatur (system/disk)' .  PHP_EOL;
echo '                    update     (system) ' . PHP_EOL;
echo '                    status     (system/disksmart/disk/raid/ups) ' . PHP_EOL;
echo '                    usage      (raid/cpu/memory/ups/network)' . PHP_EOL;
echo '                    cifs, afp, nfs, ftp, sftp, http/https, telnet, ssh, other  (services)' . PHP_EOL;
echo PHP_EOL;
echo '         -l data  - F=Fahrenheit or C=Celsius (default) ' . PHP_EOL;
echo '                    T=Terrabyte or G=Gigabyte (default) ' . PHP_EOL;
echo PHP_EOL;
echo '         Example Critical and Warning (Temperatur, Update, Status and Services (CIDS, AFP ...):' . PHP_EOL;
echo '          -w 10 -c 20 = warning > 10 and critical > 20' . PHP_EOL;
echo '          -w ~20 -c ~10 = warning < 20 and critical < 10' . PHP_EOL;
echo '          -w @5:25 -c @10:20 = warning >= 5 and <=25 and critical ≥ 10 and ≤ 20, (inside the range of {5 .. 25})' . PHP_EOL;
echo '          -w 10:20 -c 5:25 =  watning < 10 or > 20, (outside the range of {10 .. 20}) and critical < 5 or > 25, (outside the range of {5 .. 25})' . PHP_EOL;
echo PHP_EOL;
echo '         Example Critical and Warning procent (Usage)' . PHP_EOL;
echo '         -w 80 -c 90 = warning > 80% and critical > 90% (raid, cpu, memory, disksmart) '. PHP_EOL;
echo '         -w 50 -c 25 = warning < 50% and critical < 25% (ups) '. PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}

switch ($mode) {
   case 'system':
     $snmp_oid='1.3.6.1.4.1.6574.1';
     break;
   case 'uptime':
     $snmp_oid='.1.3.6.1.2.1.25.1.1.0';
     break;
   case 'disk':
     $snmp_oid='1.3.6.1.4.1.6574.2';
     break;
   case 'raid':
     $snmp_oid='1.3.6.1.4.1.6574.3';
     break;
   case 'ups':
     $snmp_oid='1.3.6.1.4.1.6574.4';
     break;
   case 'disksmart':
     $snmp_oid='1.3.6.1.4.1.6574.5';
     break;
   case 'service':
     $snmp_oid='1.3.6.1.4.1.6574.6';
     break;
   case 'io':
     $snmp_oid='1.3.6.1.4.1.6574.101';
     break;
   case 'spaceio':
     $snmp_oid='1.3.6.1.4.1.6574.102';
     break;
   case 'flashcache':
     $snmp_oid='1.3.6.1.4.1.6574.103';
     break;
   case 'iscsilun':
     $snmp_oid='1.3.6.1.4.1.6574.104';
     break;
   case 'ebox':
     $snmp_oid='1.3.6.1.4.1.6574.105';
     break;
   case 'ha':
     $snmp_oid='1.3.6.1.4.1.6574.106';
     break;
   case 'gpuinfo':
     $snmp_oid='1.3.6.1.4.1.6574.108';
     break;
   case 'memory':
     $snmp_oid='1.3.6.1.4.1.2021.4';
     break;
   case 'cpu':
     $snmp_oid='1.3.6.1.4.1.2021.11';
     break;
   case 'test':
     $snmp_oid='.1.3.6.1.2.1.2.2.1.16';
     break;
   case 'network':
     $snmp_oid='.1.3.6.1.2.1.31.1.1.1.1';
     break;
   default:
     echo "Error, no correct mode" . PHP_EOL;
     exit(2);
}


if ( $debug_snmp == true ) { 
    $snmp_oid_get=$snmp_oid;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}


if ( $mode == 'uptime' ) {
    $uptime=preg_split('/ /' , get_snmp($snmp_oid));
    $uptime=fct_uptime(preg_replace("/[^0-9\.]/", "",$uptime[1]));
    echo 'OK - ' . $uptime . PHP_EOL;
    exit(0);
} 


switch ($test) {  

   case "usage":
     $state=array(0,'OK');

     if ($mode == "network" ) {
       $num=0;
       $interface=get_string($snmp_oid . '.' . $number);
       $networkspeed=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.2.2.1.5.' . $number));
       while ( $num < 5 ) {
         $num=$num + 1;

         $in_start=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.31.1.1.1.6.' . $number));
         $out_start=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.31.1.1.1.10.' . $number));
         sleep(3);
         $in_stop=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.31.1.1.1.6.' . $number));
         $out_stop=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.31.1.1.1.10.' . $number));
       
         $in_b=(int)$in_stop[1] - (int)$in_start[1];
         $in=($in_b*8*100);
         $in=$in/(3*$networkspeed[1]);

         $out_b=(int)$out_stop[1]-(int)$out_start[1];
         $out=($out_b*8*100);
         $out=$out/(3*$networkspeed[1]);
      
         $in_bW=$in_b/3/1000/1000;
         $out_bW=$out_b/3/1000/1000;
         $in_format='MB'; 
         $out_format='MB'; 

         if ( $in_bW < 1 ) { 
           $in_bW=$in_bW*1024; 
           $in_format='KB'; }
         if ( $out_bW < 1 ) { 
           $out_bW=$out_bW*1024;
           $out_format='KB'; } 

         if ( ( $in <= 100 &&  $in >= 0 ) && ( $out <= 100 && $out >= 0 )) {
            if ( $crit != "" ) {
              if ( intval($crit) < $in || intval($crit) < $out )
                 { $state=array(2,'CRITICAL'); }
              elseif ( $warn != "" ) {
                 if ( intval($warn) < $in || intval($warn) < $out )
                   { $state=array(1,'WARNING'); }
               }
           }


           echo $state[1] . ' - ' .  $interface . ': In: ' . number_format($in,2) . '% (' . number_format($in_bW,2,".","") . ' ' . $in_format . '/s )';
           echo   ' - Out: ' . number_format($out,2) . '% (' . number_format($out_bW,2,".","") . ' ' . $out_format . '/s) ';
           echo   '| IN=' . number_format($in,2) . '%;' . $warn . ';' . $crit . ';0;100 OUT=' . number_format($out,2) .'%;' . $warn . ';' . $crit .';0;100' . PHP_EOL;
           exit($state[0]); 
         }
        }
       echo 'UNKNOWN - ' . $interface . PHP_EOL;
       exit(3); 
     }


     if ($mode == "ups" ) {
         $snmp_oid_get=$snmp_oid . ".3.6.1.0";      
         $ups_min=preg_split('/ /' , get_snmp($snmp_oid_get));
         $snmp_oid_get=$snmp_oid . ".3.1.1.0";      
         $ups_charge=preg_split('/:/' , get_snmp($snmp_oid_get));
         $ups_charge=number_format($ups_charge[2],0,",","");
         if ( $crit != "" ) {
             if ( intval($crit) > $ups_charge )
               { $state=array(2,'CRITICAL'); }
             elseif ( $warn != "" ) {
                 if ( intval($warn) > $ups_charge)
                   { $state=array(1,'WARNING'); }
               }
           }
        echo $state[1] . " - Charged: " . $ups_charge . '% (Seconds: ' . $ups_min[1] . ') | Charged='. $ups_charge . '%;' . intval($warn) . ';' . intval($crit) . ';; Seconds=' . $ups_min[1] . PHP_EOL;
        exit($state[0]);
     }



     if ($mode == "cpu" ) {
        $cpu_user=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.11.9.0'));
        $cpu_system=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.11.10.0'));
        $cpu_idle=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.11.11.0'));
        $cpu_iowait=100 -  $cpu_system[1] - $cpu_user[1] - $cpu_idle[1];
        $cpu_total=$cpu_user[1] + $cpu_system[1];
        if ( $crit != "" ) {
             if ( intval($crit) < $cpu_total )
               { $state=array(2,'CRITICAL'); }
             elseif ( $warn != "" ) {
                 if ( intval($warn) < $cpu_total)          
                   { $state=array(1,'WARNING'); }
               }
           }

        echo $state[1] . " - " . $cpu_total . '% (User: ' . $cpu_user[1] . '% System: ' . $cpu_system[1] . '% I/O Wait: ' . $cpu_iowait . '% Idle: ' . $cpu_idle[1] . '%)|Cpu=' . $cpu_total . '%;' . intval($warn). ';' . intval($crit) . ';; User=' . $cpu_user[1] . '% System=' . $cpu_system[1] . '% IOWait=' . $cpu_iowait . '% Idle=' . $cpu_idle[1] .'%' . PHP_EOL;
        exit($state[0]);
     }

     if ($mode == "memory" ) {
        $mem_total=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.5.0'));
        $mem_free=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.6.0'));
        $mem_buffer=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.14.0'));
        $mem_cached=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.15.0'));
        $mem_buffercached=$mem_cached[1] + $mem_buffer[1];
        $mem_used=$mem_total[1] - $mem_buffercached - $mem_free[1];
        $mem_used_p=number_format($mem_used / $mem_total[1] * 100,"1",".","");


        $warning=number_format($mem_total[1] / 100 * intval($warn),0,"","");
        $critical=number_format($mem_total[1] / 100 * intval($crit),0,"","");


        if ( $crit != "" ) {
             if ( $critical < $mem_used )
               { $state=array(2,'CRITICAL'); }
             elseif ( $warn != "" ) {
                 if ( $warning < $mem_used)          
                   { $state=array(1,'WARNING'); }
               }
           }
       
        echo $state[1] . " - " . $mem_used_p . "% (" . $mem_used . "KB) | TOTAL=" . $mem_total[1] . 'KB;;;; USED=' . $mem_used . 'KB;;;; FREE= ' . $mem_free[1] . 'KB;;;; CACHES=' . $mem_buffercached . "KB;;;;" . PHP_EOL; 
        exit($state[0]);
     }
     elseif ($mode == "raid" ) {
        $snmp_oid_get=$snmp_oid . ".1.1.2." .  ($number - 1);
        $raid_name=get_string($snmp_oid_get);

        $snmp_oid_get=$snmp_oid . ".1.1.4." .  ($number - 1);
        $raid_free=preg_split('/ /' , get_snmp($snmp_oid_get));

        $snmp_oid_get=$snmp_oid . ".1.1.5." .  ($number - 1);
        $raid_total=preg_split('/ /' , get_snmp($snmp_oid_get));

        if ( $data == "t" ) { 
          $raid_used=number_format(($raid_total[1]-$raid_free[1]) / 1024 / 1024 / 1024 / 1024,3,".",""); 
          $warning=number_format($raid_total[1] / 1024 / 1024 / 1024 / 1024 / 100 * intval($warn),3,".",""); 
          $critical=number_format($raid_total[1] / 1024 / 1024 / 1024 / 1024 / 100 * intval($crit),3,".",""); 
          $raid_total=number_format($raid_total[1] / 1024 / 1024 / 1024 / 1024,3,".","");
          $raid_free=number_format($raid_free[1] / 1024 / 1024 / 1024 / 1024,3,".",""); 
          $data="TB"; }
        else {
          $raid_used=number_format(($raid_total[1]-$raid_free[1]) / 1024 / 1024 / 1024,3,".",""); 
          $warning=number_format($raid_total[1] / 1024 / 1024 / 1024 / 100 * intval($warn),3,".",""); 
          $critical=number_format($raid_total[1] / 1024 / 1024 / 1024 / 100 * intval($crit),3,".",""); 
          $raid_total=number_format($raid_total[1] / 1024 / 1024 / 1024,3,".","");
          $raid_free=number_format($raid_free[1] / 1024 / 1024 / 1024,3,".",""); 
          $data="GB"; }
        
       if ( $warn != "" ) {
          if ( $warning < $raid_used)          
            { $state=array(1,'WARNING'); }
       }
       if ( $crit != "" ) {
          if ( $critical < $raid_used )
            { $state=array(2,'CRITICAL'); }
        }
        if ( $raid_free == 0 and $raid_used == 0 and $raid_total == 0 ){
        echo 'CRITICAL - no Raid' . PHP_EOL;
        exit(2);
        }
        else { echo $state[1] . " - " . $raid_name . ': ' . "Free: " . $raid_free . " ". $data . " , Used: " . $raid_used . " " . $data . " , Total: " . $raid_total . " " . $data . "| used=" .$raid_used . $data .";" . $warning . ";" . $critical . ";;" .$raid_total. PHP_EOL; 
              exit($state[0]); }
             

     }
     break;

   case "temperatur":
     if ( $data != 'f' ) 
         { $data = "c"; }
     if ( $mode == "system" ) { 
         $snmp_oid_get=$snmp_oid . ".2.0";      
         $temperatur=preg_split('/ /' , get_snmp($snmp_oid_get)); 
         $temperatur=number_format($temperatur[1],2,".","");
         
         $state=get_state('C', $crit, $temperatur);
         if ($state[0] == 0 ) {
             $state=get_state('W', $warn, $temperatur);
         }
         echo  $state[1] . " - " . $temperatur . ' °' . strtoupper($data) . ' | Temperatur=' . $temperatur . ';' . preg_replace("/[^0-9\.]/", "", $warn) . ';' . preg_replace("/[^0-9\.]/", "", $crit) . PHP_EOL;
         exit($state[0]);
         
     }
     elseif ( $mode == "disk" ) {
         $snmp_oid_get=$snmp_oid . ".1.1.6." .  ($number - 1);
         $temperatur=preg_split('/ /' , get_snmp($snmp_oid_get)); 
         if ( $temperatur[1] == '' ) {
           echo 'CRITICAL - no disk' . PHP_EOL;
           exit(2); }
         $temperatur=number_format($temperatur[1],2,".","");

         $state=get_state('C', $crit, $temperatur);
         if ($state[0] == 0 ) {
             $state=get_state('W', $warn, $temperatur);
         }
         echo  $state[1] . " - " . $temperatur . ' °' . strtoupper($data) . ' | Temperatur=' . $temperatur . ';' . preg_replace("/[^0-9\.]/", "", $warn) . ';' . preg_replace("/[^0-9\.]/", "", $crit) . PHP_EOL;
         exit($state[0]);
     }
     break;


   case "status":

     $state=array (0,'OK');
    
     if ( $mode == "system" ) {
        $snmp_oid_get=$snmp_oid . ".1.0";
        $system_status=preg_split('/ /' , get_snmp($snmp_oid_get));
        if ( $system_status[1] == 1 ) {
           $system_status="OK"; }
        else {
           $system_status="CRITICAL"; 
           $state=array(2,'CRITICAL'); }
        
        $snmp_oid_get=$snmp_oid . ".3.0";
        $system_power=preg_split('/ /' , get_snmp($snmp_oid_get));
        if ( $system_power[1] == 1 ) {
           $system_power="OK"; }
        else {
           $system_power="CRITICAL"; 
           $state=array(2,'CRITICAL'); }
        
        $snmp_oid_get=$snmp_oid . ".4.1.0";
        $system_fan=preg_split('/ /' , get_snmp($snmp_oid_get));
        if ( $system_fan[1] == 1 ) {
           $system_fan="OK"; }
        else {
           $system_fan="CRITICAL"; 
           $state=array(2,'CRITICAL'); }
         
        $snmp_oid_get=$snmp_oid . ".4.2.0";
        $system_cpufan=preg_split('/ /' , get_snmp($snmp_oid_get));
        if ( $system_cpufan[1] == 1 ) {
           $system_cpufan="OK"; }
        else {
           $system_cpufan="CRITICAL"; 
           $state=array(2,'CRITICAL'); }

        echo $state[1] . ' - ' . 'System: ' . $system_status . " - Powerstatus: " . $system_power . " - Fan: " . $system_fan . " - CpuFan: ". $system_cpufan . PHP_EOL;
        exit($state[0]);
     }


     if ( $mode == "disksmart" ) {
         $snmp_oid_get="1.3.6.1.4.1.6574.5.1.1.2.1";
         $snmp=1;
         $disk=0;   
         $status='';
         $disk_old='';
         $disk_id_1=false;
         $disk_new=false;
         while ( get_string($snmp_oid_get) != '' ) {
           $snmp_oid_get="1.3.6.1.4.1.6574.5.1.1.2." . $snmp;
           $disk_status=get_string($snmp_oid_get);
 
           if ( $disk_status == '' ) {
             break;
           }
 
           if ( $disk_status != $disk_old )
             { 
               $disk_id_1=false;
               $snmp_oid_get="1.3.6.1.4.1.6574.2.1.1.3." . ($disk); 
               $disk_model=get_string($snmp_oid_get);
               if ( substr($disk_model,0,2) == "WD" or substr($disk_model,0,7) == "Samsung" ) 
                  { $disk_id_1 = true; }

               $disk = $disk + 1; 
               $disk_old=$disk_status; 
               if ( $disk > 1 ) { $disk_new = true ;} 
             } 
            

          
           $snmp_oid_get="1.3.6.1.4.1.6574.5.1.1.3." . $snmp;
           $disk_info=get_string($snmp_oid_get);
           $snmp_oid_get="1.3.6.1.4.1.6574.5.1.1.9." . $snmp;
           $disk_result=get_string($snmp_oid_get);
           $snmp_oid_get="1.3.6.1.4.1.6574.5.1.1.4." . $snmp;
           $disk_id=get_string($snmp_oid_get);
           $snmp_oid_get="1.3.6.1.4.1.6574.5.1.1.8." . $snmp;
           $disk_raw=get_string($snmp_oid_get);

           //TEST
           //if ( $disk == 1 and $disk_id == 5 ) { $disk_raw=40; }
           //if ( $disk == 1 and $disk_id == 197 ) { $disk_raw=10; }
           //if ( $disk == 1 and $disk_id == 198 ) { $disk_raw=20; }
          // if ( $disk == 2 ) { $disk_id_1=false; }
          // if ( $disk == 2 and $disk_id=1) { $disk_raw=20; }
 
 
           $disksmart[$disk][$disk_id] = array( 
                                      "disk" => $disk,
                                      "disk_model" => $disk_model,
                                      "disk_info" => $disk_info,
                                      "disk_result" => $disk_result,
                                      "disk_raw" => $disk_raw, 
                                      "disk_id" => $disk_id, 
                                      "disk_id_1" => $disk_id_1 );


         $snmp = $snmp + 1;
         } //END WHILE           
         if ( $debug == true ) 
           { print_r($disksmart); 
           }
         $disk_new=0;
         $disk_nr=0;

         foreach ( $disksmart as $disk ) {
              $disk_nr=$disk_nr+1;
              if ( $disk[5]['disk_raw'] >= $crit and $crit > 0 ) {
                if ( $disk_new == 0 ) {
                  $status=$status . 'Disk: ' . $disk[5]['disk'] . ' -  ' . $disk[5]['disk_info']. '('. $disk[5]['disk_id'] . ')=' . $disk[5]['disk_raw']; 
                  $disk_new = 1; } 
                else { 
                  $status=$status . '; Disk: ' . $disk[5]['disk'] . ' - ' . $disk[5]['disk_info']. '(' . $disk[5]['disk_id'] . ')=' . $disk[5]['disk_raw']; 
                }
                $state[1]='CRITICAL';
                $state[0]=2;
              }

              elseif ( $disk[5]['disk_raw'] >= $warn and $warn > 0) {
                if ( $disk_new == 0 ) {
                  $status=$status . 'Disk: ' . $disk[5]['disk'] . ' - ' . $disk[5]['disk_info'] . '(' . $disk[5]['disk_id'] . ')=' . $disk[5]['disk_raw'];
                  $disk_new=1;
                }
                else {
                  $status=$status . '; Disk: ' . $disk[5]['disk'] . ' - ' . $disk[5]['disk_info'] . '(' . $disk[5]['disk_id'] . ')=' . $disk[5]['disk_raw'];
                }
                if ( $state[0] != 2 ) {
                  $state[1]='WARNING';
                  $state[0]=1; 
                }
              }

              elseif ( $disk[1]['disk_id_1'] == true and $disk[1]['disk_raw'] > 0) {
                if ( $disk_new == 0 ) {
                  $status=$status . 'Disk: ' . $disk[1]['disk'] . ' - ' . $disk[1]['disk_info']. '(' . $disk[1]['disk_id'] . ')=' . $disk[1]['disk_raw']; 
                  $disk_new=1;
                }
                else {
                  $status=$status . '; Disk: ' . $disk[1]['disk'] . ' - ' . $disk[1]['disk_info']. '(' . $disk[1]['disk_id'] . ')=' . $disk[1]['disk_raw']; 
                }
                if ( $state[0] != 2 ) {
                  $state[1]='WARNING';
                  $state[0]=1; 
                } 
              }

              elseif ( $disk[5]['disk_raw'] > 0 and $disk[197]['disk_raw'] > 0 and $disk[198]['disk_raw'] > 0 ) {
                if ( $disk_new == 0 ) {
                  $status=$status . 'Disk: ' . $disk[1]['disk'] . ' - ' . $disk[5]['disk_info']. '(' . $disk[5]['disk_id'] . ')=' . $disk[5]['disk_raw'] . ', ' . $disk[197]['disk_info']. '(' . $disk[197]['disk_id'] . ')=' . $disk[197]['disk_raw'] . ', ' . $disk[198]['disk_info']. '(' . $disk[198]['disk_id'] . ')=' . $disk[198]['disk_raw']; 
                  $disk_new=1;
                }
                else {
                  $status=$status . '; Disk: ' . $disk[1]['disk'] . ' - ' . $disk[5]['disk_info']. '(' . $disk[5]['disk_id'] . ')=' . $disk[5]['disk_raw'] . ', ' . $disk[197]['disk_info']. '(' . $disk[197]['disk_id'] . ')=' . $disk[197]['disk_raw'] . ', ' . $disk[198]['disk_info']. '(' . $disk[198]['disk_id'] . ')=' . $disk[198]['disk_raw']; 
                }
                if ( $state[0] != 2 ) {
                  $state[1]='WARNING';
                  $state[0]=1; 
                }
              }

           } 
           if ( $status != '')  { $status = ' [' . $status .']'; }
           echo $state[1] . ' - Disksmart: ' . $disk_nr . ' '  . $status . PHP_EOL; 
           exit($state[0]);

     break;
     }
 


     if ( $mode == "disk" ) {

       if ( $num === true ) {
        $snmp_oid_get=$snmp_oid . ".1.1.2." .  ($number - 1);
        $diskid=get_string($snmp_oid_get);       

        $snmp_oid_get=$snmp_oid . ".1.1.3." .  ($number - 1);
        $diskmodel=get_string($snmp_oid_get);

        $snmp_oid_get=$snmp_oid . ".1.1.4." .  ($number - 1);
        $disktype=get_string($snmp_oid_get);       

        $snmp_oid_get=$snmp_oid . ".1.1.5." .  ($number - 1);
        $status_disk=preg_split('/ /' , get_snmp($snmp_oid_get));

        $status=$synology_diskstatus[$status_disk[1] - 1]; 
        
        $state=get_state('C', $crit, $status_disk[1]);
        if ($state[0] == 0 ) {
            $state=get_state('W', $warn, $status_disk[1]);
        }
        if ( $diskid == '' ) {
            echo 'CRITICAL - no disk' . PHP_EOL;
            exit(2); }
        else { echo $state[1] . " - " . $diskid . ": " . $diskmodel . " (" . $disktype . ") - ". $status . PHP_EOL;
               exit($state[0]); }
      }
       else { 
          $diskstate=array(0,0,0,0,0,"","","","");
          while ( $disk++ <= 1024 ) {
             $snmp_oid_get=$snmp_oid . ".1.1.5." .  ($disk - 1);
             $status_disk=preg_split('/ /' , get_snmp($snmp_oid_get));
             $status=$synology_diskstatus[$status_disk[1] - 1];
             switch ($status) {
                case 'Normal': 
                    $diskstate[0]=$diskstate[0] + 1;
                    break;
                case 'Initalized': 
                    $diskstate[1]=$diskstate[1] + 1;
                    if ( $diskstate[1] = 1 ) {
                         $diskstate[5]=$disk; }
                    else {
                         $diskstate[5]=$diskstate[5] . ',' . $disk; }
                    break;
                case 'NotInitialized': 
                    $diskstate[2]=$diskstate[2] + 1;
                    if ( $diskstate[2] = 1 ) {
                         $diskstate[6]=$disk; }
                    else {
                         $diskstate[6]=$diskstate[6] . ',' . $disk; }
                    break;
                case 'SystemPartitionFailed': 
                    $diskstate[3]=$diskstate[3] + 1;
                    if ( $diskstate[3] = 1 ) {
                         $diskstate[7]=$disk; }
                    else {
                         $diskstate[7]=$diskstate[7] . ',' . $disk; }
                    break;
                case 'Crashed': 
                    $diskstate[4]=$diskstate[4] + 1;
                    if ( $diskstate[4] = 1 ) {
                         $diskstate[8]=$disk; }
                    else {
                         $diskstate[8]=$diskstate[8] . ',' . $disk; }
                    break;
                default:
                    break 2;
              }
 
          }
          if ( $diskstate[3] > 0 ||  $diskstate[4] > 0 ) 
              { $state[0]='CRITICAL'; 
                $state[1]=2; }
          elseif ( $diskstate[1] > 0 || $diskstate[2] > 0 )
             { $state[0]='WARNING';
                $state[1]=1; }
          else 
             { $state[0]='OK';
                $state[1]=0; }
       $n=4;
       while ( $n++ < 8 ) {
       if ( $diskstate[$n] != '' ) 
          { $diskstate[$n] = ' (' . $diskstate[$n] . ')'; }
       }

              
       echo $state[0] . ' - Normal: ' . $diskstate[0] . ' - Initalized: ' . $diskstate[1] .  $diskstate[5] . ' - NotInitalized: ' . $diskstate[2] . $diskstate[6] . ' - SystemPartitionFailed: ' . $diskstate[3] . $diskstate[7] . ' - Crashed: ' . $diskstate[4] . $diskstate[8]  . PHP_EOL;
       exit($state[1]);
       }    
     }

     if ( $mode == "raid" ) {
        $snmp_oid_get=$snmp_oid . ".1.1.2." .  ($number - 1);
        $raid_name=get_string($snmp_oid_get);       

        $snmp_oid_get=$snmp_oid . ".1.1.3." .  ($number - 1);
        $status_raid=preg_split('/ /' , get_snmp($snmp_oid_get));


        $status=$synology_raidstatus[$status_raid[1]- 1]; 


        if ( $crit > 0 ) {
          $state=get_state('C', $crit, $status_raid[1]);
        }
        

        if ( $status == '' ) {
          $state=array(2,"CRITICAL"); 
          $raid_name='no Raid'; 
          $status='empty'; }
        elseif ($state[0] == 0 and $warn > 0 ) {
              $state=get_state('W', $warn, $status_raid[1]); 
            }
        elseif ($state[0] == 0 and $status_raid[1] > 0 ) {
            $state=array(1,'WARNING');
            } 
        echo $state[1] . " - " . $raid_name . ": " . $status . PHP_EOL; 
        exit($state[0]);
       }

     if ( $mode == 'ups' ) {
        $snmp_oid_get=$snmp_oid . ".1.1." .  ($number - 1);
        $ups_name=get_string($snmp_oid_get);       
        $snmp_oid_get=$snmp_oid . ".1.2." .  ($number - 1);
        $ups_manuf=get_string($snmp_oid_get);       
        $snmp_oid_get=$snmp_oid . ".2.1." .  ($number - 1);
        $ups_status=get_string($snmp_oid_get);       
        if ( $ups_status == "OL" ) {
          $state=array(0,'OK'); }
        elseif ( $ups_status == "LB" ) {
            $state=array(1,'WARNING'); }
        else {
          $state=array(1,'CRITICAL'); }
        echo $state[1] . ' - ' . $ups_manuf . " " . $ups_name . ": " .$ups_status . PHP_EOL; 
        exit($state[0]);
     }
     break;



   case "update":
     if ( $mode == "system" ) {
        $snmp_oid_get=$snmp_oid . ".5.1.0";
        $model=get_string($snmp_oid_get);

        $snmp_oid_get=$snmp_oid . ".5.2.0";
        $serial=get_string($snmp_oid_get);

        $snmp_oid_get=$snmp_oid . ".5.3.0";
        $version=get_string($snmp_oid_get);

        $snmp_oid_get=$snmp_oid . ".5.4.0";
        $status_update=preg_split('/ /' , get_snmp($snmp_oid_get));
        $update=$synology_updatestatus[$status_update[1] - 1]; 

        $state=get_state('C', $crit, $status_update[1]);
        if ($state[0] == 0 ) {
            $state=get_state('W', $warn, $status_update[1]);
        }

        echo $state[1] . " - " . $model . " - " . $serial . " - " . $version . " - " . $update  . PHP_EOL;
        exit($state[0]);
      }
         
     break;


   default:
       $key=array_search($test,$synology_system);
       if ( false !== $key ) 
           { get_status(); }
       else   
           { echo 'Error -t test, no correct test value! Please check help - /usr/bin/php check_synology.php -h' . PHP_EOL; }
       break;
         
}

?>
