#!/usr/bin/php
<?php
/**
 * PHP NAGIOS check epson projector over snmp (linux/windows) 
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20220328';

$arg=1;
$debug=false;
$debug_snmp=false;

$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';

$data='';


function fct_uptime($uptime){
$sec =  $uptime / 100              % 60;
$min = ($uptime / (100*60)       ) % 60;
$hours   = ($uptime / (100*60*60)   ) % 24;
$days    =  $uptime / (100*60*60*24);
  return floor($days) . ' days, ' . $hours . ' hours, ' . $min . ' minutes, ' . $sec  . ' seconds';
}


function get_snmp($snmp_oid_get) {
    global $disk, $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp ,$snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get,1000000,5 );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get,1000000,5 );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get,1000000,5 );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get,1000000,5 );
        }
     }
    if ( $snmp === false ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2);
    } 
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}

function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}


while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
		case '-m':
			$mode=@$argv[$arg+1];
			break;
		case '-w':
			$warn=@$argv[$arg+1];
			break;
		case '-c':
			$crit=@$argv[$arg+1];
			break;
	}
	$arg = $arg + 2;
}

$state=array(0,'OK');

if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_uptime.php -H [home] -P [snmp_version] ( -d (debug) -V (snmp debug))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto. (DES/AES)] -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo '        -m lamptime' . PHP_EOL;
echo '           status' . PHP_EOL;
echo '           uptime' . PHP_EOL;
echo '           video' . PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}

$snmp_oid='1.3.6.1.4.1.1248.4.1.1.1.9.0';

if ( $debug_snmp == true ) { 
    print_r(get_snmp($snmp_oid));
    exit(0);
}


$projector=array('01'=>'Standby',
                 '02'=>'Warmup',
                 '03'=>'Normal',
                 '04'=>'Cool Down',
                 'FF'=>'Abnormal'); 


$projector_warning=array('0000'=>'OK',
			 '0001'=>'Lamp life',
			 '0002'=>'OK No signal',
			 '0003'=>'OK Unsupported signal',
			 '0004'=>'Air filter',
			 '0005'=>'High temperature');

$projector_critical=array('0000'=>'OK',
	     		  '0001'=>'Lamp ON failure',
			  '0002'=>'Lamp lid',
			  '0003'=>'Lamp burnout (ON, then OFF)',
			  '0004'=>'Fan',
			  '0005'=>'Temperature sensor',
			  '0006'=>'High temperature',
			  '0007'=>'Interior (system)');


switch ( $mode ) {
  case 'status':
    $snmp_oid='1.3.6.1.4.1.1248.4.1.1.1.9.0';
    $projector_status=preg_split('/ /', get_snmp($snmp_oid));
    $projector_lamp_status=preg_replace("/[^0-9\.]/", "",$projector_status[1]); 
    $warning=preg_replace("/[^0-9\.]/", "",$projector_status[2]); 
    $critical=preg_replace("/[^0-9\.]/", "",$projector_status[3]); 
    if ( $projector_lamp_status=="FF" or $critical != '0000' ) 
      { $state[1]='CRITICAL';
        $state[0]=2; }
    elseif ( $warning != '0000' ) 
       { $state[1]='WARNING';
         $state[0]=1; }

    echo $state[1] . ' - ' . $projector[$projector_lamp_status] . ' (Warning: ' . $projector_warning[$warning] . ', Critical: ' . $projector_critical[$critical].')'. PHP_EOL;
    
    exit($state[0]);
    break;
 
  case 'lamptime':
    $snmp_oid='1.3.6.1.4.1.1248.4.1.1.1.1.0';
    $lamp_time=preg_split('/ /', get_snmp($snmp_oid));
    if ( $crit != '' and $lamp_time[1] >= $crit ) {
       $state[1]='CRITICAL';
       $state[0]=2;
    }
    elseif ( $warn != '' and $lamp_time[1] >= $warn ) {
       $state[1]='WARNING';
       $state[0]=1;
    }
       
    echo $state[1] . ' - lamp time: ' . $lamp_time[1] . ' hours | lamptime=' . $lamp_time[1] . 'h;' . $warn. ';' . $crit . ';0;99999' . PHP_EOL;
    exit($state[0]);
    break;


  case 'uptime':
    $snmp_oid='1.3.6.1.2.1.1.3.0';
    $uptime=preg_split('/ /' , get_snmp($snmp_oid));
    $uptime=fct_uptime(preg_replace("/[^0-9\.]/", "",$uptime[1]));
    $system=get_string('1.3.6.1.2.1.1.1.0');
    $version=get_string('1.3.6.1.4.1.1248.4.1.1.1.8.0');
    echo 'OK - ' . $system . ' [' . $version  . '] - ' . $uptime . PHP_EOL; 
    exit(0);
    break;

  case 'video':
    $snmp_oid='1.3.6.1.4.1.1248.4.1.1.1.2.2.0';
    $hz=str_replace('"','' , get_snmp($snmp_oid));
    $hz=preg_split('/ /' ,$hz);
    $snmp_oid='1.3.6.1.4.1.1248.4.1.1.1.4.0';
    $video=preg_split('/ /' , get_snmp($snmp_oid));
    $video_a=str_replace('"', "", $video[1]);
    $video_b=str_replace('"', "", $video[2]);

    echo 'OK - repetition rate: ' . $hz[1] . ' Hz, resolution: ' . $video_a . ' x ' . $video_b . PHP_EOL; 
    exit(0);
    break;

}


?>
