#!/usr/bin/php
<?php
/**
 * REST API usage Openhab by nagios
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

/* Changed
   correct warning/critical

   add multiplier

   group critical

   errors php8.1

   add -A = averaage since a date 

   change state number if OK

   "label -" to "label: " 

   Changed 
   state+ sort
   group sort
   gcontact/gcontact+ sort
   gwitch/gswitch+ sort
*/

$version='1.20240513^^';

$host='';
$prot='http';
$port='8080';
$token='';
$modeitem='';
$result='';
function unique_array($array, $key) {
    $temp_array = array();
    $i = 0;
    $key_array = array();
   
    foreach($array as $val) {
        if (!in_array($val[$key], $key_array)) {
            $key_array[$i] = $val[$key];
            $temp_array[$i] = $val;
        }
        $i++;
    }
    return $temp_array;
}

function get_sort($sum,$print) 
{
  $print_sum=0;
  $print_result="";
  sort($print);
  while ( $print_sum++ < $sum ) {
    if ( $print_sum == 1 ) {
      $print_result=$print[0]; }
    else {
      $print_result=$print_result . ', ' . $print[$print_sum-1]; }
  }
  return $print_result;
}

function getITEM($item)
{
      global $host, $prot, $port , $token, $debug, $mode ;
      $url = $prot . "://" . $host . ":" .  $port . "/rest/items/" . $item;
      $handle = curl_init();

      curl_setopt_array($handle,
             array(
                CURLOPT_URL           => $url,
                CURLOPT_HEADER  => "Content-type: text/plain",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_USERPWD => $token,
                CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
                CURLOPT_TIMEOUT => 15,
             )
      );
      $json = curl_exec($handle);
      if ( $debug == true )  {
        echo PHP_EOL;
        print_r($json);
        echo PHP_EOL;
        echo PHP_EOL;
      }
      curl_close($handle);
     
      $state = json_decode($json);
      $message = $state->error->message;
      if ( @$message != '' ) { 
        echo 'UNKNOWN - ' . $message . ' - http-code: ' . $state->error->{"http-code"} . PHP_EOL; 
        exit(3); }
      else { 
        if ( $mode == 'group' || $mode == 'gcontact' || $mode == 'gcontact+' || $mode == 'gswitch' || $mode == 'gswitch+' ) {
           $result=$state;
        }
        else {
          $result = $state->state;
        } 
        return  $result;
      }
}
function getTHING($thing)
{
      global $host, $prot, $port, $token, $debug , $mode, $unique;
      $online=0;
      $offline=0;
      $offline_name='';
      $unknown=0;
      $unknown_name='';
      $sum=0;
      if (!isset($no_thing)) $no_thing = [];
      if ( $mode == 'state' ) {
         $url = $prot . "://" . $host . ":" .  $port . "/rest/things/" . $thing; }
      else {   
         $url = $prot . "://" . $host . ":" .  $port . "/rest/things/"; 
         $no_thing = explode(',',$thing); }
      $handle = curl_init();

      curl_setopt_array($handle,
             array(
                CURLOPT_URL           => $url,
                CURLOPT_HEADER  => "Content-type: text/plain",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
                CURLOPT_USERPWD => $token,
                CURLOPT_TIMEOUT => 15,
             )
      );
      $json = curl_exec($handle);
      if ( $json === false ) {
          echo 'UNKNOWN - no connection' . PHP_EOL;
          exit(3); }

      if ( $debug == true )  {
        echo PHP_EOL;
        print_r($json);
        echo PHP_EOL;
        echo PHP_EOL;
      }
      curl_close($handle);
      if ( $mode == 'state' ) {
        $state = json_decode($json);
        $result = array($state->statusInfo->status,
                          $state->statusInfo->statusDetail,
                          $state->label);
        }
      else {
        $state_array = json_decode($json);
        $array_num=0;
        foreach ( $state_array as $state ) {
          $result[$array_num] = array( $state->statusInfo->status,
                           $state->statusInfo->statusDetail,
                           $state->label);
          $array_num=$array_num+1;
         }
         if ( $unique == true ) {
           $result_array = unique_array($result, 2); }
         else {
           $result_array = $result; }

         foreach ( $result_array as $result ) {
          if ( $result[1] != "DISABLED" ) {
             if (!is_array($no_thing)) $no_thing = [];
             if ( array_search($result[2],$no_thing) === false ) {
              $sum=$sum+1;
              if ( $result[0] == 'ONLINE' ) {
                $online=$online + 1; }
              elseif ( $result[0] == 'OFFLINE' ) {
                $offline=$offline + 1; 
                if ( $offline > 1 ) { 
                  $offline_name = $result[2] . ', ' . $offline_name; }
                else {
                  $offline_name = $result[2];
                }
              }
              else {
                $unknown=$unknown + 1;
                if ( $unknown > 1 ) { 
                  $unknown_name = $result[2] . ', ' . $unknown_name; }
                else {
                  $unknown_name = $result[2];
                } 
              }
            }
          }
        }
        $result=array($sum,$online,$offline,$offline_name,$unknown,$unknown_name);
      }

      return  $result;
}


function get_thing_by_item($item) {
      global $host, $prot, $port, $token, $debug , $mode, $unique;
      $online=0;
      $offline=0;
      $offline_name;
      $sum=0;
      $url = $prot . "://" . $host . ":" .  $port . "/rest/things/";
      $handle = curl_init();

      curl_setopt_array($handle,
             array(
                CURLOPT_URL           => $url,
                CURLOPT_HEADER  => "Content-type: text/plain",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
                CURLOPT_USERPWD => $token,
                CURLOPT_TIMEOUT => 15,
             )
      );
      $json = curl_exec($handle);
      $thing=json_decode($json);

      foreach($thing AS $thing_item ) {
        foreach ($thing_item->channels as $thing_item_channels ) {
          foreach ($thing_item_channels->linkedItems as $thing_item_channels_linkedItems ) {
            if ( $thing_item_channels_linkedItems == $item ) {
              if ( $debug == true ) {
                echo "Item       :  " . $thing_item_channels_linkedItems . PHP_EOL;
                echo "Thing      : " . $thing_item->UID . PHP_EOL;
                echo "State      : " . $thing_item->statusInfo->status . PHP_EOL;
                echo "StateDetail: " . $thing_item->statusInfo->statusDetail . PHP_EOL;
                print_r($thing_item);
              }
              $result=array($thing_item->statusInfo->status,$thing_item->statusInfo->statusDetail);
              return $result;
              break; 
            }
          }
        }
      }



      if ( $debug == true )  {
        echo PHP_EOL;
        print_r($thing);
        echo PHP_EOL;
        echo PHP_EOL;
      }
      if ( $json === false ) {
          echo 'UNKNOWN - no connection' . PHP_EOL;
          exit(3); }
}

function numberstatus($status,$warncrit) {
    $numstate=0;
    $len=strlen($warncrit);
    $pos_a=stripos($warncrit,'@');
    $pos_d=stripos($warncrit,':');
    $pos_n=stripos($warncrit,'~');

    if ( is_numeric($pos_a) and is_numeric($pos_d)   )
      { $numstate = 1; }
    elseif ( is_numeric($pos_n) )
      { $numstate = 5;  }
    elseif ( $pos_d == 0 and is_numeric($pos_d) )
      { $numstate = 2; }
    elseif ( $pos_d > 0)
      { $numstate = 4; }
    elseif ( $pos_d == $len )
      { $numstate = 3; }


    //echo $numstate . PHP_EOL;

    switch ($numstate ) {
      case "1":
        $warncrit=str_replace("@","",$warncrit);
        $critical=explode(":",$warncrit);
        if ( intval($status) >= intval($critical[0])  and  intval($status) <= intval($critical[1]) )
           {
            $state=1;}
        else {
            $state=0; }
        break;

    case "4":
      $critical=explode(":",$warncrit);
      if (( intval($status) < intval($critical[0])) or (intval($status) > intval($critical[1])) )
           {
          $state=1; }
      else {
          $state=0; }
      break;

    case "5":
      $warncrit=str_replace("~","",$warncrit);
      if ( intval($status) < intval($warncrit)  )
        {
          $state=1; }
      else {
          $state=2; }

      break;

    default:
      if ( intval($status) > intval($warncrit) )
        {
          $state=1; }
        else {
          $state=0; }
   }
   //echo $state . PHP_EOL;
   return $state;
}


function number($status,$warn,$crit) {
  $numstate=0;
  if ( $status == '' ) {
    echo 'UNKNOWN - no connection' . PHP_EOL; 
    exit(3);
  }
  $state=array(0,'OK');
  if ($warn != '' or $crit !='' ) 
    {    
    $statenum=numberstatus($status,$crit);
    if ( $statenum == 1 ) 
      { $state=array(2,'CRITICAL'); }
    else {
      $statenum=numberstatus($status,$warn);
      if ( $statenum == 1 ) 
        { $state=array(1,'WARNING'); }
      } 
    }

  return $state;
}


$mode='';
$warn='';
$crit='';
$arg=1;
$debug=false;
$help=false;
$unique=false;
$pos_a='';
$pos_d='';
$pos_t='';
$gwarn=0;
$gcrit=0;
$label='';
$glabel='name';
$numberformat=2;
$item='';
$multiplier=1;
$startenergy='';

while ($arg <= $argc) {
switch ( @$argv[$arg] ) {
  case '-H':
     $host=@$argv[$arg+1];
     break;
  case '-m':
     $mode=strtolower(@$argv[$arg+1]);
     break;
  case '-w':
     $warn=@$argv[$arg+1];
     break;
  case '-c':
     $crit=@$argv[$arg+1];
     break;
  case '-mp':
     $multiplier=@$argv[$arg+1];
     break;
  case '-s':
     $prot="https";
     $arg=$arg - 1;
     break;
  case '-P':
     $port=@$argv[$arg+1];
     break;
  case '-d':
     $arg=$arg - 1;
     $debug=true;
     break;
  case '-t':
     $arg=$arg - 1;
     $thingitem=true;
     break;
  case '-h':
     $arg=$arg - 1;
     $help=true;
     break;
  case '-U':
     $arg=$arg - 1;
     $unique=true;
     break;
  case '-gl':
     $arg=$arg - 1;
     $glabel='label';
     break;
  case '-i':
     $item=@$argv[$arg+1];
     break;
  case '-mi':
     $modeitem=@$argv[$arg+1];
     break;
  case '-T':
     $token=@$argv[$arg+1];
     break;
  case '-u':
     $user=@$argv[$arg+1];
     break;
  case '-p':
     $password=@$argv[$arg+1];
     break;
  case '-l':
     $label=@$argv[$arg+1];
     break;
  case '-N':
     $numberformat=@$argv[$arg+1];
     break;
  case '-A':
     $dateenergy=@$argv[$arg+1];
     $startenergy=@$argv[$arg+2];
     $arg=$arg + 1;
     break;
  case '-C':
     $config=@$argv[$arg+1];
     if ( file_exists($config) === false )
     {
     $arg=$arg - 1;
       if ( file_exists(dirname(__FILE__). '/' . $config) === true )
         { $config=dirname(__FILE__) . '/' . $config; }
       else
         { $config=dirname(__FILE__) . '/openhab.php'; }
     }
     break;
}


$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( file_exists($config) === true ) {
   require_once($config);
}


if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_openhab.php -H [Openhab Server] -P [Port] -m [mode] -i [Item/Thing or Group] ( -u user -p [password] (or -T [Token]) -U =unique -mi [numbertype/findstring] -A [YYYY-mm-dd] [startnumber] -mp [multiplier]  -w [Warning] -c [Critical] -s =https -l [label] -gl =group label -C [configfile] -d =debug -h =help)' . PHP_EOL;
echo '        mode - Number + warn crit     = number value (Item)' . PHP_EOL;
echo '               Contact or Contact+    = Contact (Open - Critical, Closed - OK (Item)), Contact+ (Closed - Critical, Open - OK (Item))' . PHP_EOL;
echo '                                        disabled thing will not counted' . PHP_EOL;
echo '               Switch  or Switch+     = Switch (On - Critical, Off - OK (Item)), Switch+ (Off - Critical, On - OK (Item))' . PHP_EOL;
echo '                                        disabled thing will not counted' . PHP_EOL;
echo '               State                  = Offline - Critical, Online - OK (Thing)' . PHP_EOL;
echo '               State+                 = total of Things Online/ Offline with warning and critcal (-i comma separated don\'t test things) '. PHP_EOL;
echo '                                        disabled thing will not counted' . PHP_EOL;
echo '               Date                   = print date in format D.M.Y H:m:s (Item)' . PHP_EOL;
echo '               String or String+      = find a string in a string to get OK or find a String to get Critical' . PHP_EOL;
echo '               Group                  = test a hole group (only numbers)' . PHP_EOL;
echo '               GContact or GContact+  = test a hole group of Contacts (Open - Critical, Closed - OK (Item)), GContact+ (Closed - Critical, Open - OK (Item))' . PHP_EOL;
echo '               GSwitch  or GSwitch+   = test a hole group of Switch (On - Critical, Off - OK (Item)), GSwitch+ (Off - Critical, On - OK (Item))' . PHP_EOL;
echo PHP_EOL;
echo '        numbertype - Temperatur       = °C (mode number)' . PHP_EOL;
echo '                   - Humidity         = %  (mode number)' . PHP_EOL;
echo '                   - Pressure         = kPa (mode number)' . PHP_EOL;
echo '                   - Battery          = % (mode number)' . PHP_EOL;
echo '                   - Lightsensor      = lx (mode number)' . PHP_EOL;
echo '                   - every unit       = unit (mode number)' . PHP_EOL;
echo '                    or String to find/ not find (String/String+)' . PHP_EOL;
echo PHP_EOL;
echo '        -A  only number - set Date to calculate average with a startnumber' . PHP_EOL;
echo '            ( -A [YYYY-mm-dd] [startnumber] ' . PHP_EOL;
echo PHP_EOL;
echo '        -mp only number  - multiplie the number' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
echo '        -t  only number/Contact(+)/State(+) test if thing of an item is ONLINE or OFFLINE' . PHP_EOL;
echo PHP_EOL;
echo '        -U  only State+, unique Things' . PHP_EOL;
echo PHP_EOL;
echo '        -gl can be used to print the label of an item instead of the name (Group/GContact/Gcontact+/Gswitch/Gswitch+)' . PHP_EOL;
echo PHP_EOL;
echo '        Token - since openhab 3.0 you can create a token to access the rest api.' . PHP_EOL; 
echo '                You can create it in the web interface of openhab' . PHP_EOL;
echo PHP_EOL;
echo '        -C  config file (default=openhab.php) instead of the controller parameters -H, -P, -s, -T (you can specify any file with path)' . PHP_EOL;
echo '            example:' . PHP_EOL;
echo PHP_EOL;
echo '            <?php' . PHP_EOL;
echo '            $host=\'192.168.2.216\';       # IP or Hostname Openhab Server ' . PHP_EOL;
echo '            $port=\'8080\';                # Openhab Port ' . PHP_EOL;
echo '            $prot=\'http\';                # Value http or https ' . PHP_EOL;
echo '            $token=\'\'                    # Token ' . PHP_EOL;
echo '            $user=\'\'                     # User ' . PHP_EOL;
echo '            $password=\'\'                 # Password ' . PHP_EOL;
echo '            ?> ' . PHP_EOL;
echo PHP_EOL;
echo '        Example Critical and Warning Numbers:' . PHP_EOL;
echo '        -w 10 -c 20 = warning > 10 and critical > 20' . PHP_EOL;
echo '        -w ~20 -c ~10 = warning < 20 and critical < 10' . PHP_EOL;
echo '        -c @10:20 = critical ≥ 10 and ≤ 20, (inside the range of {10 .. 20})' . PHP_EOL;
echo '        -c 10:20 = critical < 10 or > 20, (outside the range of {10 .. 20})' . PHP_EOL;
echo '        -w 10:20 -c 5:25 =  watning < 10 or > 20, (outside the range of {10 .. 20}) and critical < 5 or > 25, (outside the range of {5 .. 25})' . PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;

exit(0);
}

if ( @$user != '' ) 
  { $token = $user . ':' . $password; }

if ( $label != '' ) {
   switch ( $mode ) {
        case 'group':
        case 'gcontact':
        case 'gcontact+':
        case 'gswitch':
        case 'gswitch+':
            $label = $label . ' ';
            break;
        default:
            $label = $label . ': ';
   }
}
switch (strtolower($modeitem)) {
       case 'temperatur':
         $unit='°C';
         break;
       case 'lightsensor':
         $unit='lx';
         break;
       case 'humidity':
       case 'density':
       case 'battery':
         $unit ='%';
         break;
       case 'pressure':
         $unit='kPa' ;
         break;
       default:
         $unit=$modeitem;
         $modeitem='default';
         break;
    }


switch ("$mode") {
  case 'group':
     $string=getITEM('');
     $group=count($string);
     $group_num=0;
     $num=0;
     $ok=0;
     $warning=0;
     $critical=0;
     $startwarn=$warn;
     $startcrit=$crit;
     $offline=0;
     while ( $num++ < $group ) {
       if (isset($string[$num]->groupNames)) {
       if ( array_search($item,$string[$num]->groupNames) > -1 ) {
         $state=number($string[$num]->state,$startwarn,$startcrit);
         $status=get_thing_by_item($string[$num]->name);
         if ( $status[1] != "DISABLED" ) {
           if ( $status[0] == 'ONLINE' ) {
             $group_num=$group_num + 1;
             switch ($state[0]) { 
               case 0:
                 $ok=$ok + 1;
                 break;
               case 1:
                 $warning=$warning + 1;
                 $group_warning[]=$string[$num]->$glabel. '=' . number_format($string[$num]->state,2,".","") . $unit;  
                 break;
               case 2: 
                 $critical=$critical + 1;
                 $group_critical[]=$string[$num]->$glabel . '=' . number_format($string[$num]->state,2,".","") . $unit;
                 break; 
             }
           }
           else {
             if ( $thingitem === true ) {
               $group_num=$group_num + 1;
               $offline=$offline + 1;
               $group_offline[]=$string[$num]->$glabel; 
             }
           } 
         }
       } 
      }
     }
     if ($offline > 0 ) {
      $offline_item=get_sort($offline,$group_offline);
     }
     
     if ($warning > 0 ) {
       $warning_item=get_sort($warning,$group_warning);
     }
     if ($critical > 0 ) {
       $critical_item=get_sort($critical,$group_critical);
     }

     if ( $group_num == 0) {
       echo 'UNKNOWN - no group found' . PHP_EOL;
       exit(3); }
     else { 
       if ( $critical > 0 or $offline > 0) {
           $state=array(2,'CRITICAL');
       }
       elseif ( $warning > 0 ) {
           $state=array(1,'WARNING');
       } 
       else {
           $state=array(0,'OK');
       }
       echo $state[1] . ' - ' . $label . ' Total: ' . $group_num. ' - Warninig: ' . $warning;
       if ( $warning_item != '' ) {
           echo  ' (' . $warning_item . ')';
       }
       echo  ' - Critical: ' . $critical; 
       if ( $critical_item != '' ) {
           echo ' (' . $critical_item . ')';
       }
       if ( $offline > 0 ) {
         echo ' - Offline: ' . $offline . ' (' . $offline_item . ')';
       } 
       echo ' | TOTAL=' . $group_num . ';;;; OK=' . $ok . ' WARNING=' . $warning . ' CRITICAL=' . $critical . PHP_EOL;
       exit($state[0]);   
     }
  break;

  case  'string+' :
    $string=getITEM("$item");
    $state='OK';
    $numstate=0; 
    if ( substr_count($string, $unit) > 0 )
      { echo 'OK - ' . $label . $string . PHP_EOL; 
        exit(0); }
    elseif ( substr_count( $string, $unit) == 0 )
      { echo 'CRITICAL - ' . $label . $string . PHP_EOL; 
        exit(2); }
    else 
      { echo 'UNKNOWN - no connection' . PHP_EOL; 
        exit(3); }
    break;

  case  'string' :
    $string=getITEM("$item");
    $state='OK';
    $numstate=0; 
    if ( substr_count($string, $unit) == 0 )
      { echo 'OK - ' . $label . $string . PHP_EOL; 
        exit(0); }
    elseif ( substr_count($string, $unit) > 0 )
      { echo 'CRITICAL - ' . $label . $string . PHP_EOL; 
        exit(2); }
    else 
      { echo 'UNKNOWN - no connection' . PHP_EOL; 
        exit(3); }
    break;

  case  'number' :
    $thingstatus='';
    $status=getITEM("$item") * $multiplier;
    $state=number($status,$warn,$crit); 
    $num=number_format((float)$status,$numberformat);
    if ( "$modeitem" == "" )
      { $modeitem="Number"; }
    else { 
      $modeitem=strtolower($modeitem);
    }

    if ( $thingitem == true ) {
       $status=get_thing_by_item($item);
       if ( $status[0] != "ONLINE" ) {
         $state=array(2,"CRITICAL");
         $num=0;
       }
     }
    if ( $startenergy != '' ) {
      $datestart=date('Y-m-d', time());
      $dateget = date_diff(date_create($dateenergy), date_create($datestart));
      $datediff = $dateget->format('%a');
      $energydiff = $num - $startenergy;
      $average=mb_chr(248);
      $average_num=number_format($energydiff / $datediff,4);
      echo $state[1] . ' - ' . $thingstatus . $label . $num . ' ' . $unit . ' - ' . $dateenergy .'(' . $datediff . '): ' . $energydiff . ' ' . $unit . ' - ' . $average . ': ' . $average_num . ' ' . $unit . '  | Total=' . $num . $unit . ';' . intval($warn) . ';' . intval($crit) . ';;100' . ' SinceDate(' . $dateenergy . ')=' . $energydiff . $unit . ';;;; Average=' . $average_num . $unit . ';;;;'.   PHP_EOL; 
    }
    else { 
          echo $state[1] . ' - ' . $thingstatus . $label . $num . ' ' . $unit . ' | ';
      if ( $unit=="°C" ) { $unit=""; }
          echo $modeitem . '=' . $num . $unit . ';' . intval($warn) . ';' . intval($crit) . ';;100' .  PHP_EOL; 
    }

    exit($state[0]);
    break;



  case 'gcontact':
    $string=getITEM('');
    $group=count($string);
    $open=0;
    $closed=0;
    $group_num=0;
    $num=0; 
    $offline=0;
    while ( $num++ < $group ) {
      if (isset($string[$num]->groupNames)) {
        if ( array_search($item,$string[$num]->groupNames) > -1 ) {
          $state=$string[$num]->state;
          $status=get_thing_by_item($string[$num]->name);
          if ( $status[1] != 'DISABLED' ) {
            $group_num=$group_num + 1;
            if ( $status[0] != 'ONLINE' ) {
              $offline = $offline + 1;
              $gcontact_offline[]=$string[$num]->$glabel;
            }    
            else {  
              if ($state == 'CLOSED' ) {
                $closed=$closed + 1; }
              elseif ($state == 'OPEN') {
                $open=$open + 1; 
                $gcontact_open[]=$string[$num]->$glabel;
              }
            }
          }
        }
      }
   }
   if ( $offline > 0) {
     $offline_item=get_sort($offline, $gcontact_offline);
   }
   if ( $open > 0) {
     $open_item=get_sort($open, $gcontact_open);
   }

   if ( $group_num == 0 ) { 
     echo 'UNKNOWN - no group found' . PHP_EOL; 
     exit(3); }
   else {
     if ( $open == 0 ) {
       if ( $thingitem === true and $offline > 0 ) {
         echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' Closed' ;
       }
       else {
         echo 'OK - ' . $label . 'Total: ' . $group_num . ' Closed' ;
         $status=0;
       }
     }
     else {
       echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' - Open: ' . $open . ' (' . $open_item . ')' ;
       $status=2;
     }

     if ( $thingitem === true ) {
       if ( $offline > 0 ) {
         echo ' - Offline: ' . $offline . ' (' . $offline_item . ')'; 
         $status=2; } 
       }
      echo PHP_EOL;
      exit($status);
     }

   if ( $status == '' ) {
     echo 'UNKNOWN - no connection' . PHP_EOL;
     exit(3);
   }
 
 break;

 case 'gcontact+':
    $string=getITEM('');
    $group=count($string);
    $closed=0;
    $open=0;
    $group_num=0;
    $num=0;
    while ( $num++ < $group ) {
      if ( isset($string[$num]->groupNames)) {
        if ( array_search($item,$string[$num]->groupNames) > -1 ) {
          $state=$string[$num]->state;
          $status=get_thing_by_item($string[$num]->name);
          if ( $status[1] != 'DISABLED' ) {
            $group_num=$group_num + 1;
            if ( $status[0] != 'ONLINE' ) {
              $offline = $offline + 1;
              $gcontact_item[]=$string[$num]->$glabel;
            }    
            else {
              if ($state == 'OPEN' ) {
                $open=$open + 1; }
              elseif ($state == 'CLOSED') {
                $closed=$closed + 1;
                $gcontact_closed[]=$string[$num]->$glabel; 
              }
            }
          }
        }
      }
    }
     
   if ( $offline > 0 ) {
     $offline_item=get_sort($offline, $gcontact_offline);
   }
   if ( $closed > 0 ) {
     $closed_item=get_sort($closed, $gcontact_closed);
   }

   if ( $group_num == 0 ) {
     echo 'UNKNOWN - no group found' . PHP_EOL;
     exit(3); }
   else {
     if ( $closed == 0 ) {
       if ( $thingitem === true and $offline == 0 ) {
         echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' Closed' ;
       }
       else {
         echo 'OK - ' . $label . 'Total: ' . $group_num . ' Closed' ;
         $status=0;
       }
     }
     else {
       echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' - Closed: ' . $closed . ' (' . $closed_item . ')' ;
     }

     if ( $thingitem === true ) {
       if ( $offline > 0 ) {
         echo ' - Offline: ' . $offline . ' (' . $offline_item . ')';
         $status=2; }
     }
     echo PHP_EOL;
     exit($status);
   }

   if ( $status == '' ) {
     echo 'UNKNOWN - no connection' . PHP_EOL;
     exit(3);
   }
 break;

 case 'gswitch':
    $string=getITEM('');
    $group=count($string);
    $closed=0;
    $open=0;
    $group_num=0;
    $num=0;
    $offline=0;
    $on=0;
    $off=0;
    if ( !isset($gswitch_offline)) $gswitch_offline=[];

    if ( !isset($gswitch_on)) $gswitch_on=[];

    while ( $num++ < $group ) {
      if ( isset($string[$num]->groupNames)) {
        if ( array_search($item,$string[$num]->groupNames) > -1 ) {
          $state=$string[$num]->state;
          $status=get_thing_by_item($string[$num]->name);
          if ( $status[1] != 'DISABLED' ) {
            $group_num=$group_num + 1;
            if ( $status[0] != 'ONLINE' ) {
              $offline = $offline + 1;
              if ( $offline == 1 ) {
                $gswitch_offline[]=$string[$num]->$glabel; }
            }    
            else {
              if ($state == 'OFF' ) {
                $off=$off + 1; }
              elseif ($state == 'ON') {
                $on=$on + 1;
                $gswitch_on[]=$string[$num]->$glabel; 
              }
            }
          }
        }
      }
    }
    if ( $offline > 0 ) {
      $offline_item=get_sort($offline, $gswitch_offline);
    }
    if ( $on > 0 ) {
      $on_item=get_sort($on, $gswitch_on);
    }

   if ( $group_num == 0 ) {
     echo 'UNKNOWN - no group found' . PHP_EOL;
     exit(3); }
   else {
     if ( $on == 0 ) {
       if ( $thingitem === true and $offline > 0 ) {
         echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' Off' ;
       }
       else {
         echo 'OK - ' . $label . 'Total: ' . $group_num . ' Off' ;
         $status=0;
       }
     }
     else {
       echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' - On: ' . $on . ' (' . $on_item . ')' ;
     }

     if ( $thingitem === true ) {
       if ( $offline > 0 ) {
         echo ' - Offline: ' . $offline . ' (' . $offline_item . ')';
         $status=2; }
     }
     echo PHP_EOL;
     exit($status);
   }

   if ( $status == '' ) {
     echo 'UNKNOWN - no connection' . PHP_EOL;
     exit(3);
   }
 break;
     

 case 'gswitch+':
    $string=getITEM('');
    $group=count($string);
    $closed=0;
    $open=0;
    $group_num=0;
    $num=0;
    $offline=0;
    $on=0;
    $off=0;
    while ( $num++ < $group ) {
      if ( isset($string[$num]->groupNames)) {
        if ( array_search($item,$string[$num]->groupNames) > -1 ) {
          $state=$string[$num]->state;
          $status=get_thing_by_item($string[$num]->name);
          if ( $status[1] != 'DISABLED' ) {
            $group_num=$group_num + 1;
            if ( $status[0] != 'ONLINE' ) {
              $offline = $offline + 1;
              $gswitch_item[]=$string[$num]->$glabel; 
            }    
            else {
              if ($state == 'ON' ) {
                $on=$on + 1; }
              elseif ($state == 'OFF') {
                $off=$off + 1;
                $gswitch_off[]=$string[$num]->$glabel; 
              }
            }
          }
        }
      }
    }
    if ( $offline > 0 ) {
      $offline_item=get_sort($offline, $gswitch_offline);
    }
    if ( $on > 0 ) {
      $off_item=get_sort($off, $gswitch_off);
    }
     
   if ( $group_num == 0 ) {
     echo 'UNKNOWN - no group found' . PHP_EOL;
     exit(3); }
   else {
     if ( $off == 0 ) {
       if ( $thingitem === true and $offline > 0 ) {
         echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' On' ;
       }
       else {
         echo 'OK - ' . $label . 'Total: ' . $group_num . ' On' ;
         $status=0;
       }
     }
     else {
       echo 'CRITICAL - ' . $label . 'Total: ' . $group_num . ' - Off: ' . $off . ' (' . $off_item . ')' ;
     }

     if ( $thingitem === true ) {
       if ( $offline > 0 ) {
         echo ' - Offline: ' . $offline . ' (' . $offline_item . ')';
         $status=2; }
     }
     echo PHP_EOL;
     exit($status);
   }

   if ( $status == '' ) {
     echo 'UNKNOWN - no connection' . PHP_EOL;
     exit(3);
   }
 break;


 case 'contact':
    $status=strtolower(getITEM("$item"));
    if ( $status == '' ) {
      echo 'UNKNOWN - no connection' . PHP_EOL; 
      exit(3);
    }
    if ( $thingitem == true ) {
      $thingstatus=get_thing_by_item($item); 
      if ( $status == 'closed' and $thingstatus[0] == "ONLINE"  ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
      else { 
         echo 'CRITICAL - OFFLINE (' . $thingstatus[1] . '): ' . $label . $status . PHP_EOL;
         exit(2); }
      break; 
    }

    if ( $status == 'closed' ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
    else { 
         echo 'CRITICAL - ' . $label . $status . PHP_EOL;
         exit(2); }
    break;

  case 'contact+':
    $status=strtolower(getITEM("$item"));
    if ( $status == '' ) {
      echo 'UNKNOWN - no connection' . PHP_EOL; 
      exit(3);
    }

    if ( $thingitem == true ) {
      $thingstatus=get_thing_by_item($item); 
      if ( $status == 'open' and $thingstatus[0] == "ONLINE"  ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
      else { 
         echo 'CRITICAL - OFFLINE (' . $thingstatus[1] . '): ' . $label . $status . PHP_EOL;
         exit(2); }
      break; 
    }

    if ( $status == 'open' ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
    else { 
         echo 'CRITICAL - ' . $label . $status . PHP_EOL;
         exit(2); }
    break;

  case 'switch':
    $status=strtolower(getITEM("$item"));
    if ( $status == '' ) {
      echo 'UNKNOWN - no connection' . PHP_EOL; 
      exit(3);
    }
   
    if ( $thingitem == true ) {
      $thingstatus=get_thing_by_item($item); 
      if ( $status == 'off' and $thingstatus[0] == "ONLINE"  ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
      else { 
         echo 'CRITICAL - OFFLINE (' . $thingstatus[1] . '): ' . $label . $status . PHP_EOL;
         exit(2); }
      break; 
    }

    if ( $status == 'off' ) {
         echo 'OK - '  . $label. $status . PHP_EOL;
         exit(0); }
    else { 
         echo 'CRITICAL - ' . $label . $status . PHP_EOL;
         exit(2); }
    break;

  case 'switch+':
    $status=strtolower(getITEM("$item"));
    if ( $status == '' ) {
      echo 'UNKNOWN - no connection' . PHP_EOL; 
      exit(3);
    }

    if ( $thingitem == true ) {
      $thingstatus=get_thing_by_item($item); 
      if ( $status == 'on' and $thingstatus[0] == "ONLINE"  ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
      else { 
         echo 'CRITICAL - OFFLINE (' . $thingstatus[1] . '): ' . $label . $status . PHP_EOL;
         exit(2); }
      break; 
    }
    if ( $status == 'on' ) {
         echo 'OK - ' . $label . $status . PHP_EOL;
         exit(0); }
    else { 
         echo 'CRITICAL - ' . $label . $status . PHP_EOL;
         exit(2); }
    break;

  case 'state+':
    $status=getTHING("$item");
    
    if ( $status[4] > 0 or $status[0] == 0 ) {
      if ( $status[2] > 0 ) { 
         $offline=explode(", ", $status[3]); 
         $offline_item=get_sort($status[2],$offline);
         $status[3] = ' ('.$status[3].')'; }
      echo 'UNKNOWN - ' . $label . 'Total: '  . $status[0] .' - Online: ' . $status[1] . ' - Offline: ' . $status[2] . "( " . $offline_item . ') - Unknown: ' . $status[4] .  ' (' . $status[5] . ') | Total=' . $status[0] . ';' . $warn . ';' . $crit . ';0;' . $status[0] . ' Online=' . $status[1] . ' Offline=' . $status[2] . PHP_EOL;
      exit(3);
     } 
    $offline=explode(", ", $status[3]); 


    if ( $status[2] > 0 ) {
       $offline_item=get_sort($status[2],$offline);
    }
    
    if ($crit=='') $crit=(int)$crit;
    if ($warn=='') $warn=(int)$warn;
    if ( $status[2] > $crit ) {
         echo 'CRITICAL - ' . $label . 'Total: '  . $status[0] .' - Online: ' . $status[1] . ' - Offline: ' . $status[2] . ' (' . $offline_item . ')' ;
         echo  ' | Total=' . $status[0] . ';' . $warn . ';' . $crit . ';0;' . $status[0] . ' Online=' . $status[1] . ' Offline=' . $status[2] . PHP_EOL;
         exit(2); }
    elseif ( $status[2] > $warn ) { 
         echo 'WARNING - ' . $label . 'Total: '  . $status[0] .' - Online: ' . $status[1] . ' - Offline: ' . $status[2] . ' (' . $offline_item . ')' ; 
         echo ' | Total=' . $status[0] . ';' . $warn . ';' . $crit . ';0;' . $status[0] . ' Online=' . $status[1] . ' Offline=' . $status[2] . PHP_EOL;
         exit(1); }
    else {
         if ( $status[2] > 0 ) {
           echo 'OK - ' . $label . 'Total: '  . $status[0] .' - Online: ' . $status[1] . ' - Offline: ' . $status[2] . ' (' . $offline_item . ')' ;
           echo ' | Total=' . $status[0] . ';' . $warn . ';' . $crit . ';0;' . $status[0] . ' Online=' . $status[1] . ' Offline=' . $status[2] . PHP_EOL; }
         else { 
           echo 'OK - ' . $label . 'Total: '  . $status[0] .' - Online: ' . $status[1] . ' - Offline: ' . $status[2];  
           echo ' | Total=' . $status[0] . ';' . $warn . ';' . $crit . ';0;' . $status[0] . ' Online=' . $status[1] . ' Offline=' . $status[2] . PHP_EOL; }
         exit(0); }
    break;
    
  case 'state':
    $status=getTHING("$item");
    if ( $status[0] == 'ONLINE' ) {
         echo 'OK - ' . $label . $status[2] . ": " . $status[0] . PHP_EOL;
         exit(0); }
    elseif ( $status[0] == 'OFFLINE' ) { 
         echo 'CRITICAL - ' .$label . $status[2] . " (". $status[0] . '): ' . $status[1] . PHP_EOL;
         exit(2); }
    else { 
         echo 'UNKNOWN - no connection' . PHP_EOL; 
         exit(3); }
    break;





  case 'date':
    $status=getITEM("$item");
    if ( $status == '' ) {
      echo 'UNKNOWN - no connection' . PHP_EOL; 
      exit(3); }
    if ( $status != '' ) {
         $datum=substr($status,8,2) . "." . substr($status,5,2) ."." . substr($status,0,4) . " " . substr($status,11,2). ":" . substr($status,14,2). ":" . substr($status,17,2);
         echo 'OK - ' . $label . $datum . PHP_EOL;
         exit(0); }
    else { 
         echo 'CRITICAL - ' . $label . $status . PHP_EOL;
         exit(2); }
    break;
  default:
    echo "Error - please check help - /usr/bin/php check_openhab.php -h" . PHP_EOL;

    break;
}

?>
