#!/usr/bin/php
<?php
/**
 * PHP check Network over snmp by nagios
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

/* 
   check state of interface -S
   check state is numeric
*/
$version='1.20220406';

$if_state=array('up','down','testing','unknown','dormant','notPresent','lowerLayerDown');     

$arg=1;
$debug=false;
$debug_snmp=false;
$debug_snmp_input=false;
$debug_snmp_output=false;
$debug_snmp_state=false;
$seconds=5;
$mode='';
$warn=0;
$crit=0;
$number='1';
$num=false;
$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';
$perfdata='%';

$in_bW=0;
$out_bW=0;
$perf_max='';
$perf_format='';
$label='';
$interface='';

$data='';

function write($format) {
      global $warn, $crit, $perf_max, $in_bW, $out_bW, $label, $state, $network;
      $in_format=$format; 
      $out_format=$format; 
      echo $state[1] . ' - ' .  $label . ' (' . $network . ' Mbit/s) - In: ' . number_format($in_bW,3,".","") . ' ' . $in_format . '/s ';
      echo   ' - Out: ' . number_format($out_bW,3,".","") . ' ' . $out_format . '/s';
}
  

function get_snmp($snmp_oid_get) {
    global $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp , $snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get, 1000000,5 );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get, 1000000, 5 );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get, 1000000, 5 );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get, 1000000, 5 );
        }
     }
    
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}


function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));       
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}


while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-w':
			$warn=@$argv[$arg+1];
			break;
		case '-c':
			$crit=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-I':
			$arg=$arg - 1;
			$debug_snmp_input=true; 
			break;
		case '-O':
			$arg=$arg - 1;
			$debug_snmp_output=true; 
			break;
		case '-S':
			$arg=$arg - 1;
			$debug_snmp_state=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
		case '-n':
			$number=@$argv[$arg+1];
                        $num=true;
			break;
		case '-m':
			$perfdata=@$argv[$arg+1];
			break;
		case '-i':
			$interfacename=@$argv[$arg+1];
                        break;
		case '-o':
			$perfdata=@$argv[$arg+1];
			break;
		case '-l':
			$label=@$argv[$arg+1];
			break;
		case '-s':
			$seconds=@$argv[$arg+1];
                        if ( $seconds>60 ) {
                           $seconds=60; }
                        break;
	}
	$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_network.php -H [host] -P [snmp_version] -n [node] -i [interface_name] ( -l [label] -s [seconds (default=5, max=60)]  -o [output/perfdata] -w [Warning] -c [Critical] -d (debug) -V (debug interfaces node/name) -I (debug input interfaces) -O (debug output interfaces) -S (debug interfaces states))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto. (DES/AES)] -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo '        -n node       - network node or'  . PHP_EOL;
echo '        -i interface  - network interface name'  . PHP_EOL;
echo PHP_EOL;
echo '        -s seconds - check period (default=5, max=60)' . PHP_EOL;
echo PHP_EOL;
echo '        -o output/perfdata  b=bit' . PHP_EOL; 
echo '                            Kb=Kbit' . PHP_EOL;
echo '                            Mb=Mbit' . PHP_EOL;
echo '                            B=Byte' . PHP_EOL;
echo '                            KB=KByte' . PHP_EOL;
echo '                            MB=MByte' . PHP_EOL;
echo '                            %=percent and KByte/MByte (default)' . PHP_EOL;
echo PHP_EOL;
echo '        -l label ' . PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}


$snmp_oid='.1.3.6.1.2.1.31.1.1.1.1';
$snmp_oid_input='.1.3.6.1.2.1.2.2.1.10';
$snmp_oid_output='.1.3.6.1.2.1.2.2.1.16';
$snmp_oid_state='.1.3.6.1.2.1.2.2.1.8';

if ( $debug_snmp == true ) { 
    $snmp_oid_get=$snmp_oid;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}

if ( $debug_snmp_input == true ) { 
    $snmp_oid_get=$snmp_oid_input;
    $debug_snmp=true;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}
if ( $debug_snmp_output == true ) { 
    $snmp_oid_get=$snmp_oid_output;
    $debug_snmp=true;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}

if ( $debug_snmp_state == true ) { 
    $snmp_oid_get=$snmp_oid_state;
    $debug_snmp=true;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}

if ( @$interfacename != '' ) {
  $debug_snmp=true;
  $snmp_oid_get=$snmp_oid;
  $interfaceliste=get_snmp($snmp_oid_get);
  $interface_find=array_search("STRING: \"$interfacename\"",$interfaceliste);
  $interface_number=explode('.',$interface_find);
  $number=$interface_number[substr_count($interface_find,'.')];
  $debug_snmp=false;
}

$state=array(0,'OK');
$num=0;
$snmp_interface='.1.3.6.1.2.1.2.2.1.8.' . $number;
$interface_state=preg_split('/ /' , get_snmp($snmp_interface));
if ( is_numeric($interface_state[1]) === false ) {
  preg_match_all('!\d!', $interface_state[1] , $get_state);
  $interface_state_item=$get_state[0][0];
}
else {
  $interface_state_item=$interface_state[1];
}
 


$interface=get_string($snmp_oid . '.' . $number);


if ( $interface_state_item == 1 ) {
$networkspeed=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.2.2.1.5.' . $number));
while ( $num < 5 ) {

  $in_start=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.2.2.1.10.' . $number));
  $out_start=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.2.2.1.16.' . $number));
  $start=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.1.3.0'));
  $start=substr($start[1], 1, -1);
  sleep($seconds);
  $in_stop=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.2.2.1.10.' . $number));
  $out_stop=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.2.2.1.16.' . $number));
  $stop=preg_split('/ /' , get_snmp('.1.3.6.1.2.1.1.3.0'));
  $stop=substr($stop[1], 1, -1);
  $seconds=($stop - $start)/100;
  
  $in_b=(int)$in_stop[1] - (int)$in_start[1];
  $in=($in_b*8*100);
  $in=$in/($seconds*$networkspeed[1]);

  $out_b=(int)$out_stop[1]-(int)$out_start[1];
  $out=($out_b*8*100);
  $out=$out/($seconds*$networkspeed[1]);

  if ( ( $in <= 100 &&  $in >= 0 ) && ( $out <= 100 && $out >= 0 )) {
      if ( $crit != "" ) {
        if ( intval($crit) < $in || intval($crit) < $out )
          { $state=array(2,'CRITICAL'); }
       elseif ( $warn != "" ) {
          if ( intval($warn) < $in || intval($warn) < $out )
            { $state=array(1,'WARNING'); }
       }
    }
   break;
   }
  
  elseif ( $num == 5 ) {
       echo 'UNKNOWN - ' . $interface . PHP_EOL;
       exit(3);} 
  $num=$num + 1;
 }
  $network=$networkspeed[1]/1000/1000;


  if ( $label == '' )
    { $label=$interface; }

  switch ($perfdata) { 

    case 'b':
      $in_bW=$in_b/$seconds*8;
      $out_bW=$out_b/$seconds*8;
      $perf_in=$in_bW;
      $perf_out=$out_bW;
      write('bit');
      $perf_format='bit';
      $perf_max=$network*1000*1000;
      $perf_warn=$perf_max/100*$warn;
      $perf_crit=$perf_max/100*$crit;
    break;

    case 'Kb':
      $in_bW=$in_b/$seconds/1000*8;
      $out_bW=$out_b/$seconds/1000*8;
      $perf_in=$in_bW;
      $perf_out=$out_bW;
      write('Kbit');
      $perf_format='Kbit';
      $perf_max=$network*1000;
      $perf_warn=$perf_max/100*$warn;
      $perf_crit=$perf_max/100*$crit;
    break;

    case 'Mb':
      $in_bW=$in_b/$seconds/1000/1000*8;
      $out_bW=$out_b/$seconds/1000/1000*8;
      $perf_in=$in_bW;
      $perf_out=$out_bW;
      write('Mbit');
      $perf_format='Mbit';
      $perf_max=$network;
      $perf_warn=$perf_max/100*$warn;
      $perf_crit=$perf_max/100*$crit;
    break;


    case 'B':
      $in_bW=$in_b/$seconds;
      $out_bW=$out_b/$seconds;
      $perf_in=$in_bW;
      $perf_out=$out_bW;
      write('Byte');
      $perf_format='Byte'; 
      $perf_max=$network*1000*1000/8;
      $perf_warn=$perf_max/100*$warn;
      $perf_crit=$perf_max/100*$crit;
    break;

    case 'KB':
      $in_bW=$in_b/$seconds/1000/1000*1024;
      $out_bW=$out_b/$seconds/1000/1000*1024;
      $perf_in=$in_bW;
      $perf_out=$out_bW;
      write('KB'); 
      $perf_format='KB';
      $perf_max=$network*1024/8;
      $perf_warn=$perf_max/100*$warn;
      $perf_crit=$perf_max/100*$crit;
    break;

    case 'MB':
      $in_bW=$in_b/$seconds/1000/1000;
      $out_bW=$out_b/$seconds/1000/1000;
      $perf_in=$in_bW;
      $perf_out=$out_bW;
      write('MB');
      $perf_format='MB';
      $perf_max=$network/8;
      $perf_warn=$perf_max/100*$warn;
      $perf_crit=$perf_max/100*$crit;
    break;


          
    default:
      $in_format='MB';
      $out_format='MB';
      $in_bW=$in_b/$seconds/1000/1000;
      $out_bW=$out_b/$seconds/1000/1000;
      $perf_in=$in;
      $perf_out=$out;
      $perf_in_format='MB'; 
      $perf_out_format='MB'; 

      if ( $in_bW < 1 ) { 
        $in_bW=$in_bW*1024; 
        $in_format='KB'; }
      if ( $out_bW < 1 ) { 
        $out_bW=$out_bW*1024;
        $out_format='KB'; } 
      $perf_format='%';
      $perf_max=100;
      $perf_warn=$warn;
      $perf_crit=$crit;
      if ( is_numeric($network) === false ) { 
         echo 'CRITICAL - no connection' . PHP_EOL;
         exit(2);
      }
      echo $state[1] . ' - ' .  $label . ' (' . $network . ' Mbit/s) - In: ' . number_format($in,2) . '% (' . number_format($in_bW,3,".","") . ' ' . $in_format . '/s )';
      echo   ' - Out: ' . number_format($out,2) . '% (' . number_format($out_bW,3,".","") . ' ' . $out_format . '/s) ';
    }

    echo   '| IN=' . number_format($perf_in,3,".","") . $perf_format .';'. number_format($perf_warn,3,".","") . ';' .  number_format($perf_crit,3,".","") . ';0;' . number_format($perf_max,3,".","") . ' OUT=' . number_format($perf_out,3,".","") . $perf_format . ';' . number_format($perf_warn,3,".","") . ';' . number_format($perf_crit,3,".","") . ';0;' . number_format($perf_max,3,".","") . PHP_EOL;
    exit($state[0]); 
  }
else {
if ( $interface == '' ) {
  echo 'CRITICAL - no interface found' . PHP_EOL; }
else {
  echo  'CRITICAL - ' . $interface . ': ' . $if_state[$interface_state_item - 1] . PHP_EOL; }
exit(2);
}
?>
