#!/usr/bin/php
<?php
/**
 * PHP NAGIOS check memory over snmp (linux/windows)
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20230906';

$arg=1;
$debug=false;
$debug_snmp=false;

$mode='';
$warn=0;
$crit=0;
$number='1';
$num=false;
$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';
$system='linux';
$mem=0;
$output='Byte';
$memory='Physical';
$count=0;


function get_snmp($snmp_oid_get) {
    global $mem , $disk, $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp ,$snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get, 1000000, 5 );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get, 1000000, 5 );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get, 1000000, 5 );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get, 1000000, 5 );
        }
     }
    if ( $snmp === false && $mem == 0 ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2);
    } 
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}

function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}


while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-w':
			$warn=@$argv[$arg+1];
			break;
		case '-c':
			$crit=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-m':
			$system=@$argv[$arg+1];
			break;
		case '-vm':
			$arg=$arg - 1;
			$memory='Virtual'; 
			break;
		case '-o':
			$output=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
	}
	$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_mem.php -H [host] -P [snmp_version] (-m [system] -w [Warning] -c [Critical] -d (debug) -V (snmp debug))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto.] (DES/AES) -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo '        -m linux (default) ' . PHP_EOL;
echo '           windows ' . PHP_EOL;
echo PHP_EOL;
echo '        -o output/perfdata B=Byte (default) ' . PHP_EOL; 
echo '                           KB=KByte  ' . PHP_EOL;
echo '                           MB=MByte           ' . PHP_EOL;
echo '                           GB=GByte           ' . PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}


$state=array(0,'OK');

if ( $system == 'windows' ) {
$snmp_oid='.1.3.6.1.2.1.25.2.3.1'; } 

if ( $system == 'linux' ) {
$snmp_oid='1.3.6.1.4.1.2021.4'; }

if ( $debug_snmp == true ) { 
    $snmp_oid_get=$snmp_oid;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}
if( $system == 'windows' ) {
 while ( $mem++ < 256 ) {
   $physical=get_string($snmp_oid . '.3.' . $mem);
   if ( $physical == '' ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2); }
   if ( $physical==$memory . ' Memory' || $physical=='Physical memory' ) {
     $count = $count + $mem;
     break;
   }
  }


  if ( $count > 0 ) { 
    $memory=preg_split('/ /' , get_snmp($snmp_oid . '.4.' . $count));
    $mem_total=preg_split('/ /' , get_snmp($snmp_oid . '.5.' . $count));
    $mem_free=preg_split('/ /' , get_snmp($snmp_oid . '.6.' . $count));


    switch ($output) {
      case 'GB':
        $mem_total=number_format($memory[1]*$mem_total[1]/1024/1024/1024,3,".","");
        $mem_used=number_format($memory[1]*$mem_free[1]/1024/1024/1024,3,".","");
        $warning=number_format($mem_total / 100 * $warn,3,".","");
        $critical=number_format($mem_total / 100 * $crit,3,".","");
        break;
      case 'MB':
        $mem_total=number_format($memory[1]*$mem_total[1]/1024/1024,3,".","");
        $mem_used=number_format($memory[1]*$mem_free[1]/1024/1024,3,".","");
        $warning=number_format($mem_total / 100 * $warn,3,".","");
        $critical=number_format($mem_total / 100 * $crit,3,".","");
        break;
      case 'KB':
        $mem_total=number_format($memory[1]*$mem_total[1]/1024,0,".","");
        $mem_used=number_format($memory[1]*$mem_free[1]/1024,0,".","");
        $warning=number_format($mem_total / 100 * $warn,0,".","");
        $critical=number_format($mem_total / 100 * $crit,0,".","");
        break;
      default: 
        $mem_total=number_format($memory[1]*$mem_total[1],0,".","");
        $mem_used=number_format($memory[1]*$mem_free[1],0,".","");
        $warning=number_format($mem_total / 100 * $warn,0,"","");
        $critical=number_format($mem_total / 100 * $crit,0,"","");
        $output='Byte';
        break;
    }
   
    $mem_used_p=number_format($mem_used / $mem_total * 100,"1",".","");
    $mem_free=$mem_total-$mem_used;
    echo $state[1] . ' - ' . $mem_used_p . '% (' . $mem_used . ' ' . $output .'/' .$mem_total . ' ' . $output . ') | TOTAL=' . $mem_total . $output . ';' . $warning . ';' . $critical . ';; USED=' . $mem_used . $output . ';;;; FREE=' . $mem_free . $output . ';;;;' . PHP_EOL;
    exit($state[0]);
  } 
  else { 
    exit(2);
  }
}

else {
$mem_total=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.5.0'));
$mem_free=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.6.0'));
$mem_buffer=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.14.0'));
$mem_cached=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.4.15.0'));


    switch ($output) {
      case 'GB':
        $mem_total=number_format($mem_total[1]/1024/1024,3,".","");
        $mem_free=number_format($mem_free[1]/1024/1024,3,".","");
        $mem_buffer=number_format($mem_buffer[1]/1024/1024,3,".","");
        $mem_cached=number_format($mem_cached[1]/1024/1024,3,".","");
        $mem_buffercached=number_format($mem_cached + $mem_buffer,3,".","");
        $mem_used=number_format($mem_total - $mem_buffercached - $mem_free,3,".","");
        $warning=number_format($mem_total / 100 * $warn,3,".","");
        $critical=number_format($mem_total / 100 * $crit,3,".","");
        break;
      case 'MB':
        $mem_total=number_format($mem_total[1]/1024,3,".","");
        $mem_free=number_format($mem_free[1]/1024,3,".","");
        $mem_buffer=number_format($mem_buffer[1]/1024,3,".","");
        $mem_cached=number_format($mem_cached[1]/1024,3,".","");
        $mem_buffercached=number_format($mem_cached + $mem_buffer,3,".","");
        $mem_used=number_format($mem_total - $mem_buffercached - $mem_free,3,".","");
        $warning=number_format($mem_total / 100 * $warn,3,".","");
        $critical=number_format($mem_total / 100 * $crit,3,".","");
        break;
      case 'KB':
        $mem_total=number_format($mem_total[1],0,".","");
        $mem_free=number_format($mem_free[1],0,".","");
        $mem_buffer=number_format($mem_buffer[1],0,".","");
        $mem_cached=number_format($mem_cached[1],0,".","");
        $mem_buffercached=number_format($mem_cached + $mem_buffer,0,".","");
        $mem_used=number_format($mem_total - $mem_buffercached - $mem_free,0,".","");
        $warning=number_format($mem_total / 100 * $warn,0,".","");
        $critical=number_format($mem_total / 100 * $crit,0,".","");
        break;
      default:
        $output='Byte';
        $mem_total=number_format($mem_total[1]*1024,0,".","");
        $mem_free=number_format($mem_free[1]*1024,0,".","");
        $mem_buffer=number_format($mem_buffer[1]*1024,0,".","");
        $mem_cached=number_format($mem_cached[1]*1024,0,".","");
        $mem_buffercached=number_format($mem_cached + $mem_buffer,0,".","");
        $mem_used=number_format($mem_total - $mem_buffercached - $mem_free,0,".","");
        $warning=number_format($mem_total / 100 * $warn,0,"","");
        $critical=number_format($mem_total / 100 * $crit,0,"","");
        $output='Byte';
        break;
    }


$mem_used_p=number_format($mem_used / $mem_total * 100,"1",".","");

if ( $crit != "" ) {
     if ( $critical < $mem_used )
       { $state=array(2,'CRITICAL'); }
     elseif ( $warn != "" ) {
         if ( $warning < $mem_used)          
           { $state=array(1,'WARNING'); }
       }
   }

echo $state[1] . " - " . $mem_used_p . "% (" . $mem_used .' '. $output . '/' . $mem_total . ' ' . $output . ') | TOTAL=' . $mem_total . $output . ';' . $warning . ';' . $critical . ';; USED=' . $mem_used . $output . ';;;; FREE=' . $mem_free . $output .  ';;;; CACHES=' . $mem_buffercached . $output . ';;;;' . PHP_EOL; 
exit($state[0]);
}

?>
