#!/usr/bin/php
<?php
/**
 * PHP NAGIOS check disk over snmp (linux/windows)
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20211206';

$arg=1;
$debug=false;
$debug_snmp=false;

$mode='';
$warn=0;
$crit=0;
$number='1';
$num=false;
$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';
$system='linux';
$disk=0;
$output='Byte';
$num=0;
$num_disk='';
$count=0;
$disk_f=false;
$label='';

function get_snmp($snmp_oid_get) {
    global $disk, $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp ,$snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get );
        }
     }
    if ( $snmp === false && $disk == 0 ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2);
    } 
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}

function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}


while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-w':
			$warn=@$argv[$arg+1];
			break;
		case '-c':
			$crit=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-m':
			$system=@$argv[$arg+1];
			break;
		case '-o':
			$output=@$argv[$arg+1];
			break;
		case '-n':
			$num=@$argv[$arg+1];
			break;
		case '-D':
			$num_disk=@$argv[$arg+1];
			break;
		case '-l':
			$label=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
	}
	$arg = $arg + 2;
}



if ( $debug == false )
{ error_reporting(0); }


if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_disk.php -H [host] -P [snmp_version] (-D [name] (-n [number]) -w [Warning] -c [Critical] -d (debug) -V (snmp debug))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto. (DES/AES)] -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo '        -D disk (linux example: \'/boot\', windows example: \'c:\' ' .PHP_EOL;
echo '        or ' . PHP_EOL;
echo '        -n number (get number from -V) ' . PHP_EOL;
echo PHP_EOL;
echo '        -o output/perfdata B=Byte (default) ' . PHP_EOL; 
echo '                           KB=Kilobyte  ' . PHP_EOL;
echo '                           MB=Megabyte           ' . PHP_EOL;
echo '                           GB=Gigabyte           ' . PHP_EOL;
echo '                           TB=Terabyte           ' . PHP_EOL;
echo PHP_EOL;
echo '        -l label' .PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}


$state=array(0,'OK');

$snmp_oid='.1.3.6.1.2.1.25.2.3.1';

if ( $debug_snmp == true ) { 
    $snmp_oid_get=$snmp_oid;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}


if ( $num_disk != '' ) {
  while ( $disk++ < 256 ) {
    $physical=get_string($snmp_oid . '.3.' . $disk);
    if ( $physical == ''  && $disk == 1 ) { 
      echo 'CRITICAL - no disk found' . PHP_EOL;
      exit(2);
    }   
    if ( is_numeric(stripos($physical , $num_disk )))  {
      $count=$disk;
      if (strlen($num_disk) == 1 ) {
        if (strlen($num_disk) == strlen($physical) ) {
           $disk_f=true;
           break; }
      }
      elseif ( strpos($physical, ':') == 1 )
         {  $disk_f=true;
            break; } 
      elseif ( strlen($num_disk) == strlen($physical) )  { 
          $disk_f=true;
         break; }  
    }
  }
}

if ( $num > 0 ) {
    $count=$num; 
    $disk_f=true;
}

  if ( $count > 0 && $disk_f === true ) { 
    $disk_name=preg_split('/ /' , get_string($snmp_oid . '.3.' . $count));
    $disk_units=preg_split('/ /' , get_snmp($snmp_oid . '.4.' . $count));
    $disk_total=preg_split('/ /' , get_snmp($snmp_oid . '.5.' . $count));
    $disk_free=preg_split('/ /' , get_snmp($snmp_oid . '.6.' . $count));


    switch ($output) {
      case 'TB':
        $disk_total=number_format($disk_units[1]*$disk_total[1]/1024/1024/1024/1024,3,".","");
        $disk_used=number_format($disk_units[1]*$disk_free[1]/1024/1024/1024/1024,3,".","");
        $warning=number_format($disk_total / 100 * $warn,3,".","");
        $critical=number_format($disk_total / 100 * $crit,3,".","");
        break;
      case 'GB':
        $disk_total=number_format($disk_units[1]*$disk_total[1]/1024/1024/1024,3,".","");
        $disk_used=number_format($disk_units[1]*$disk_free[1]/1024/1024/1024,3,".","");
        $warning=number_format($disk_total / 100 * $warn,3,".","");
        $critical=number_format($disk_total / 100 * $crit,3,".","");
        break;
      case 'MB':
        $disk_total=number_format($disk_units[1]*$disk_total[1]/1024/1024,3,".","");
        $disk_used=number_format($disk_units[1]*$disk_free[1]/1024/1024,3,".","");
        $warning=number_format($disk_total / 100 * $warn,3,".","");
        $critical=number_format($disk_total / 100 * $crit,3,".","");
        break;
      case 'KB':
        $disk_total=number_format($disk_units[1]*$disk_total[1]/1024,3,".","");
        $disk_used=number_format($disk_units[1]*$disk_free[1]/1024,3,".","");
        $warning=number_format($disk_total / 100 * $warn,3,".","");
        $critical=number_format($disk_total / 100 * $crit,3,".","");
        break;
      default: 
        $disk_total=number_format($disk_units[1]*$disk_total[1],0,".","");
        $disk_used=number_format($disk_units[1]*$disk_free[1],0,".","");
        $warning=number_format($disk_total / 100 * $warn,0,".","");
        $critical=number_format($disk_total / 100 * $crit,0,".","");
        $output='Byte';
        break;
    }
    $disk_free=$disk_total-$disk_used;
    $disk_used_p=number_format($disk_used / $disk_total * 100,"1",".","");
    if ( !is_numeric($disk_used_p) ) {
        $disk_used_p=0;
    }

    if ( $label == '' ) {
      $label = $disk_name[0];
    }

    echo $state[1] . ' - ' . $label . ' ' . $disk_used_p . '% (' .$disk_used.' ' . $output . '/'. $disk_total . ' ' . $output . ') | ' . $disk_name[0] .'=' . $disk_used . $output . ';' . $warning . ';' . $critical . ';0;' . $disk_total . PHP_EOL;
    exit($state[0]);
  } 
  else { 
    echo 'CRITICAL - no disk found' . PHP_EOL;
    exit(2);
  }

?>
