#!/usr/bin/php
<?php  
/**
 * REST API usage Deconz by nagios
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20240514';

$host='';
$prot='http';
$port='80';
$debug=false;
$help=false;
$label='';
$warn=0;
$crit=0;


function get_sort($sum,$print)
{
  $print_sum=0;
  $print_result="";
  sort($print);
  while ( $print_sum++ < $sum ) {
    if ( $print_sum == 1 ) {
      $print_result=$print[0]; }
    else {
      $print_result=$print_result . ', ' . $print[$print_sum-1]; }
  }
  return $print_result;
}

function numberstatus($status,$warncrit) {
    $numstate=0;
    $len=strlen($warncrit);
    $pos_a=stripos($warncrit,'@');
    $pos_d=stripos($warncrit,':');
    $pos_n=stripos($warncrit,'~');

    if ( is_numeric($pos_a) and is_numeric($pos_d)   )
      { $numstate = 1; }
    elseif ( is_numeric($pos_n) )
      { $numstate = 5;  }
    elseif ( $pos_d == 0 and is_numeric($pos_d) )
      { $numstate = 2; }
    elseif ( $pos_d > 0)
      { $numstate = 4; }
    elseif ( $pos_d == $len )
      { $numstate = 3; }


    //echo $numstate . PHP_EOL;

    switch ($numstate ) {
      case "1":
        $warncrit=str_replace("@","",$warncrit);
        $critical=explode(":",$warncrit);
        if ( intval($status) >= intval($critical[0])  and  intval($status) <= intval($critical[1]) )
           {
            $state=1;}
        else {
            $state=0; }
        break;

    case "4":
      $critical=explode(":",$warncrit);
      if (( intval($status) < intval($critical[0])) or (intval($status) > intval($critical[1])) )
           {
          $state=1; }
      else {
          $state=0; }
      break;

    case "5":
      $warncrit=str_replace("~","",$warncrit);
      if ( intval($status) < intval($warncrit)  )
        {
          $state=1; }
      else {
          $state=2; }

      break;

    default:
      if ( intval($status) > intval($warncrit) )
        {
          $state=1; }
        else {
          $state=0; }
   }
   //echo $state . PHP_EOL;
   return $state;
}


function number($status,$warn,$crit) {
  $numstate=0;
  if ( $status == '' ) {
    echo 'UNKNOWN - no connection' . PHP_EOL; 
    exit(3);
  }
  $state=array(0,'OK');
  if ($warn != '' or $crit !='' ) 
    {    
    $statenum=numberstatus($status,$crit);
    if ( $statenum == 1 ) 
      { $state=array(2,'CRITICAL'); }
    else {
      $statenum=numberstatus($status,$warn);
      if ( $statenum == 1 ) 
        { $state=array(1,'WARNING'); }
      } 
    }

  return $state;
}

function unique_multidim_array($array, $key) {
    $temp_array = array();
    $i = 0;
    $key_array = array();
   
    foreach($array as $val) {
        if (!in_array($val[$key], $key_array)) {
            $key_array[$i] = $val[$key];
            $temp_array[$i] = $val;
        }
        $i++;
    }
    return $temp_array;
}


function callAPI($method, $url, $data){
   $curl = curl_init();
   switch ($method){
      case "DELETE":
         curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'DELETE');
         if ($data)
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: applicatioddn/json',
            ));
         break;
      case "POST":
         curl_setopt($curl, CURLOPT_POST, 1);
         if ($data)
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: applicatioddn/json',
            ));
            curl_setopt($curl, CURLOPT_POSTFIELDS, '{' . $data . '}');
         break;
      default:
         if ($data)
            $url = sprintf("%s?%s", $url, http_build_query($data));
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: applicatioddn/json',
             ));
   }
   curl_setopt($curl, CURLOPT_URL, $url);
   curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
   $result = curl_exec($curl);
   if(!$result){
     echo "Error: Connection Failure" . PHP_EOL;
     exit;
   }
   curl_close($curl);
   return $result;
}

$arg=1;
while ($arg <= $argc) {
  switch ( @$argv[$arg] ) {
    case '-H':
       $host=@$argv[$arg+1];
       break;
    case '-s':
       $prot="https";
       $arg=$arg - 1;
       break;
    case '-d':
       $debug=true;
       $arg=$arg - 1;
       break;
    case '-h':
       $help=true;
       $arg=$arg - 1;
       break;
    case '-P':
       $port=@$argv[$arg+1];
       break;
    case '-m':
       $mode=@$argv[$arg+1];
       break;
    case '-w':
       $warn=@$argv[$arg+1];
       break;
    case '-c':
       $crit=@$argv[$arg+1];
       break;
    case '-e':
       $equipment=@$argv[$arg+1];
       break;
    case '-l':
       $label=@$argv[$arg+1];
       break;
  }
$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else { 
  error_reporting(-1); }
 
if ( $help == true || $argc == 1 ) {
  echo PHP_EOL;
  echo 'Usage: /usr/bin/php check_deconz.php -H [deconz server] -P [port] -m [mode] (-e [equipment] -l label -s =https -d =debug -h =help)' . PHP_EOL;
  echo PHP_EOL;
  echo '       -m battery       - warning and critical battery equipment' . PHP_EOL;
  echo '          gbattery      - warning and critical all batteries'. PHP_EOL;
  echo '          gbattery_name - warning and critical all batteries and name warning/critical/offline equipment'. PHP_EOL;
  echo PHP_EOL;
  echo '          temperature   - warning and critical temperature equipment'. PHP_EOL;
  echo '          humidity      - warning and critical hunidity equipment'. PHP_EOL;
  echo '          pressure      - warning and critical pressure equipment'. PHP_EOL;
  echo PHP_EOL;
  echo '          openclosed    - citical open equipment'. PHP_EOL;
  echo '          closedopen    - citical closed equipment'. PHP_EOL;
  echo PHP_EOL;
  echo '        Example Critical and Warning Numbers:' . PHP_EOL;
  echo '        -w 10 -c 20 = warning > 10 and critical > 20' . PHP_EOL;
  echo '        -w ~20 -c ~10 = warning < 20 and critical < 10' . PHP_EOL;
  echo '        -c @10:20 = critical ≥ 10 and ≤ 20, (inside the range of {10 .. 20})' . PHP_EOL;
  echo '        -c 10:20 = critical < 10 or > 20, (outside the range of {10 .. 20})' . PHP_EOL;
  echo '        -w 10:20 -c 5:25 =  watning < 10 or > 20, (outside the range of {10 .. 20}) and critical < 5 or > 25, (outside the range of {5 .. 25})' . PHP_EOL;
  echo PHP_EOL;
  echo 'Version: ' . $version . PHP_EOL;
  echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
  echo PHP_EOL;
  echo PHP_EOL;
  exit(0);
}

$conf=dirname(__FILE__) . '/' . $host . '.conf';
if ( is_file($conf)) {
  require_once($conf);
  $get_data = callAPI('GET', $prot . '://' . $host . ':' . $port . '/api/' .$apikey, false);
  $response = json_decode($get_data, true);
  if ( array_key_exists('error', $response)) { 
    $error_description=$response[0]['error']['description'];
    echo 'Error: ' . $error_description . PHP_EOL;
  }
  $sensors = $response['sensors'];
  $config = $response['config'];
  sort($sensors);
  

  switch($mode) {
    case 'gbattery':
    case 'gbattery_name':
      $num=0;
      $b_sum=0;
      $b_ok=0;
      $b_warn=0;
      $b_crit=0;
      $b_offline=0;
      $b_state=array(0,'OK');
      $b_warn_name='';
      $b_crit_name='';
      $b_offline_name='';
      $no_sensors = explode(',',@$equipment);
      
      foreach($sensors as &$value ) {
        if ( array_key_exists('battery', $value['config']) and array_search($value['name'],$no_sensors) === false ) {
          $b_sensors[$num]=array('name' => $value['name'],
                                 'reachable' => $value['config']['reachable'],
                                 'battery' => $value['config']['battery']); 
          $num=$num+1;
        }
      }
      $b_sensors=unique_multidim_array($b_sensors,'name');
      foreach($b_sensors as &$value ) {
          $b_sum=$b_sum + 1;
          if ( $value['reachable'] == 1 ) { 
            $state=number($value['battery'],$warn,$crit);        

            if ( $state[0] == 0 ) {
              $b_ok=$b_ok + 1;
            }
            elseif ( $state[0] == 1 ) {
              $b_warn=$b_warn + 1;
              if ( $b_state[0] < 2 ) {
                $b_state=array(1,'WARNING)');
              }
              if ( $mode == 'gbattery_name' ) {
                  $warn_name[]=$value['name'] . '=' . $value['battery'] . '%'; 
              }
            }
            else {
              $b_crit=$b_crit + 1;
              $b_state=array(2,'CRITICAL');
              if ( $mode == 'gbattery_name' ) {
                  $crit_name[]=$value['name'] . '=' . $value['battery'] . '%'; 
              }
            }
          }
          else {
            $b_offline=$b_offline + 1;
            $b_state=array(2,'CRITICAL');
            if ( $mode == 'gbattery_name' ) {
                  $offline_name[]=$value['name']; 
            }
          }
      }

      if ( $mode == 'gbattery' ) { 
        echo $b_state[1] . ' - Total: ' . $b_sum . ' OK: ' . $b_ok . ' Warning: ' . $b_warn . ' Critical: ' . $b_crit . ' Offline: ' . $b_offline. PHP_EOL;
      }
      else {
        echo $b_state[1] . ' - Total: ' . $b_sum . ' OK: ' . $b_ok . ' Warning: ' . $b_warn ;
        if ( $b_warn > 0 ) {
          $b_warn_name=get_sort($b_warn, $warn_name);
          echo ' (' . $b_warn_name . ')';
        }
        echo '  Critical: ' . $b_crit ;
        if ( $b_crit > 0 ) { 
          $b_crit_name=get_sort($b_crit, $crit_name);
          echo ' (' . $b_crit_name . ')';
        }
        echo ' Offline: ' . $b_offline ;
        if ( $b_offline > 0 ) {
          $b_offline_name=get_sort($b_offline, $offline_name);
          echo ' (' . $b_offline_name , ')';
        }
        echo PHP_EOL;
      }
      exit($b_state[0]);
      break;

    case 'battery':
      foreach ($sensors as &$value) {
        if ( array_key_exists('battery', $value['config'])) {
          if ( $equipment == $value['name'] ) {
            $battery= $value['config']['battery'];
            $state=number($battery,$warn,$crit);
            if ( $label == '' ) {
              $label = $value['name'];
            }
            echo $state[1] . ' - ' . $label . ': ' .  $battery . '% | battery=' . $battery . '%' . PHP_EOL;
            exit($state[0]);
          }
        }
      }
      echo 'UNKNOWN - ' . $equipment . ' battery not exist!' . PHP_EOL;
      exit(3);
      break;


    case 'temperature':
      foreach ($sensors as &$value) {
        if ( array_key_exists('temperature', $value['state'])) {
          if ( $equipment == $value['name'] ) {
            $temperature= $value['state']['temperature']/100;
            $state=number($temperature,$warn,$crit);
            if ( $label == '' ) {
              $label = $value['name'];
            }
            echo $state[1] . ' - ' . $label . ': ' .  $temperature . '°C | temperature=' . $temperature . '°C' . PHP_EOL;
            exit($state[0]);
          }
        }
      }
      echo 'UNKNOWN - ' . $equipment . ' temperature not exist!' . PHP_EOL;    
      exit(3);
      break;
       
    case 'pressure':
      foreach ($sensors as &$value) {
        if ( array_key_exists('pressure', $value['state'])) {
          if ( $equipment == $value['name'] ) {
            $pressure= $value['state']['pressure'];
            $state=number($pressure,$warn,$crit);
            if ( $label == '' ) {
              $label = $value['name'];
            }
            echo $state[1] . ' - ' . $label . ': ' .  $pressure . ' hPa | pressure=' . $pressure . 'hPa' . PHP_EOL;
            exit($state[0]);
          }
        }
      }
      echo 'UNKNOWN - ' . $equipment . ' pressure not exist!' . PHP_EOL;
      exit(3);
      break;

    case 'humidity':
      foreach ($sensors as &$value) {
        if ( array_key_exists('humidity', $value['state'])) {
          if ( $equipment == $value['name'] ) {
            $humidity= $value['state']['humidity']/100;
            $state=number($humidity,$warn,$crit);
            if ( $label == '' ) {
              $label = $value['name'];
            }
            echo $state[1] . ' - ' . $label . ': ' .  $humidity . '% | humidity=' . $humidity . '%' . PHP_EOL;
            exit($state[0]);
          }
        }
      }
      echo 'UNKNOWN - ' . $equipment . ' humidity not exist!' . PHP_EOL;
      exit(3);
      break;

    case 'openclosed':
      $state=array(0,'OK');
      $status='closed';
      foreach ($sensors as &$value) {
        if ( array_key_exists('open', $value['state'])) {
          if ( $equipment == $value['name'] ) {
            if ( $value['state']['open'] == 1 ) {
              $state=array(2,'CRITICAL');
              $status='open';
            }
            if ( $label == '' ) {
              $label = $value['name'];
            }
            echo $state[1] . ' - ' . $label . ': ' .  $status . PHP_EOL;
            exit($state[0]);
          }
        }
      }
      echo 'UNKNOWN - ' . $equipment . ' openclosed not exist!' . PHP_EOL;
      exit(3);
      break;

    case 'closedopen':
      $state=array(0,'OK');
      $status='open';
      foreach ($sensors as &$value) {
        if ( array_key_exists('open', $value['state'])) {
          if ( $equipment == $value['name'] ) {
            if ( $value['state']['open'] != 1 ) {
              $state=array(2,'CRITICAL');
              $status='closed';
            }
            if ( $label == '' ) {
              $label = $value['name'];
            }
            echo $state[1] . ' - ' . $label . ': ' .  $status . PHP_EOL;
            exit($state[0]);
          }
        }
      }
      echo 'UNKNOWN - ' . $equipment . ' openclosed not exist!' . PHP_EOL;
      exit(3);
      break;


    default:
      echo 'Error: ' . $mode . ' not exists!'. PHP_EOL;
      exit(2);
  }
}
else {
  echo 'Error: ' . $conf . ' not exists!'. PHP_EOL;
  exit(2);
}
exit;
?>
