#!/usr/bin/php
<?php  
/**
 * REST API usage Deconz by nagios
 * Create Config
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20220804';

$host='';
$prot='http';
$port='80';
$debug=false;
$help='false';

function callAPI($method, $url, $data){
   $curl = curl_init();
   switch ($method){
     case "DELETE":
         curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'DELETE');
         if ($data)
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: applicatioddn/json',
            ));
         break;
      case "POST":
         curl_setopt($curl, CURLOPT_POST, 1);
         if ($data)
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: applicatioddn/json',
            ));
            curl_setopt($curl, CURLOPT_POSTFIELDS, '{' . $data . '}');
         break;
      default:
         if ($data)
            $url = sprintf("%s?%s", $url, http_build_query(array('false')));
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: applicatioddn/json',
             ));
   }
   curl_setopt($curl, CURLOPT_URL, $url);
   curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
   $result = curl_exec($curl);
   if(!$result){
     echo "Error: Connection Failure" . PHP_EOL;
     exit;
   }
   curl_close($curl);
   return $result;
}

$arg=1;
$delete=false;
while ($arg <= $argc) {
  switch ( @$argv[$arg] ) {
    case '-H':
       $host=@$argv[$arg+1];
       break;
    case '-m':
       $mode=@$argv[$arg+1];
       break;
    case '-s':
       $prot="https";
       $arg=$arg - 1;
       break;
    case '-d':
       $debug=true;
       $arg=$arg - 1;
       break;
    case '-P':
       $port=@$argv[$arg+1];
       break;
  }
$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else { 
  error_reporting(-1); }
 
if ( $help === true or $argc == 1 ) {
  echo PHP_EOL;
  echo 'Usage: /usr/bin/php deconz_config.php -H [deconz server] -P [port] -m mode ( -s =https -d =debug -h =help)' . PHP_EOL;
  echo PHP_EOL;
  echo 'DEFAULT: ' . PHP_EOL;
  echo 'In a new browser tab open the Phoscon App' . PHP_EOL;
  echo 'Click on Menu → Settings → Gateway' . PHP_EOL;
  echo 'Click on “Advanced” button' . PHP_EOL;
  echo 'Click on the “Authenticate app” button' . PHP_EOL;
  echo PHP_EOL;
  echo 'now start the deconz_config.php to get an apikey for your nagios server' . PHP_EOL;
  echo PHP_EOL;
  echo PHP_EOL;
  echo '-m create       create apikey and config file' . PHP_EOL;
  echo '   config	list all apikeys' . PHP_EOL;
  echo '   delete       delete hosts config file and apikey' . PHP_EOL;
  echo '   sensors      list all sensors' . PHP_EOL;
  echo PHP_EOL;
  echo PHP_EOL;
  echo 'Version: ' . $version . PHP_EOL;
  echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
  echo PHP_EOL;
  exit;
}



switch ( $mode ) {
  case 'sensors':
  $conf=dirname(__FILE__) . '/' . $host . '.conf';
  if ( is_file($conf)) {
    require_once($conf);
    $get_data = callAPI('GET', $prot . '://' . $host . ':' . $port . '/api/' . $apikey , 'false' );
    $response = json_decode($get_data, true);
    print_r($response['sensors']);
  }
  else {
    echo 'no config file found - ' . $host . '.conf' . PHP_EOL;
  }
  exit; 
  break;

  case 'config':
  $conf=dirname(__FILE__) . '/' . $host . '.conf';
  if ( is_file($conf)) {
    require_once($conf);
    $get_data = callAPI('GET', $prot . '://' . $host . ':' . $port . '/api/' . $apikey . '/config/' , 'false' );
    $response = json_decode($get_data, true);
    print_r($response['whitelist']);
  }
  else {
    echo 'no config file found - ' . $host . '.conf' . PHP_EOL;
  }
  exit; 
  break;

  case 'delete': 
  $conf=dirname(__FILE__) . '/' . $host . '.conf';
  if ( is_file($conf)) {
    require_once($conf);
    //$apikey='F2C9808E44';
    $get_delete = callAPI('DELETE', $prot . '://' . $host . ':' . $port . '/api/' .$apikey . '/config/whitelist/' . $apikey , false);

    //$host='192.168.2.231';
    //$conf=dirname(__FILE__) . '/' . $host . '.conf';

    if ( ! unlink($conf) ) {
      echo 'error delete config file - ' . $conf . PHP_EOL;
    }
    else {
      echo 'config deleted - ' . $conf . PHP_EOL;
    }
  }
  else {
    echo 'no config file found - ' . $host . '.conf' . PHP_EOL;
  }
  exit; 
  break;

default: 
$get_data = callAPI('POST', $prot . '://' . $host . ':' . $port . '/api/' , '"devicetype": "nagios"');
$response = json_decode($get_data, true);
if ( array_key_exists('0', $response)) {
  if ( array_key_exists('error', $response[0])) { 
    $error_description=$response[0]['error']['description'];
    echo 'Error: ' . $error_description . PHP_EOL;
  }
  elseif ( array_key_exists('success' , $response[0])) {
    $apikey=$response[0]['success']['username'];
    if ( file_put_contents('./' . $host . '.conf', '<?php $apikey="' . $apikey . '" ?>' )) {
      echo 'config file ' . './' . $host . '.conf created' . PHP_EOL;
    }
    else { 
      echo 'Error: creating config file ' . './' . $host . '.conf' . PHP_EOL;
    }
  } 
}
exit;
break;
}
?>
