#!/usr/bin/php
<?php
/**
 * PHP NAGIOS check load/cpu over snmp (linux/windows)
 *
 * Author : Jörg Hörter
 * Mail   : info@jhoerter.com
 *
 */

$version='1.20220328';

$arg=1;
$debug=false;
$debug_snmp=false;

$mode='';
$warn=0;
$crit=0;
$number='1';
$num=false;
$help=false;

$host='';
$snmp_version=2;
$snmp_community='public';
$snmp_privprot='';
$snmp_privpassword='';
$snmp_oid='';
$snmp_get='';
$cpu=0;
$data='';
$mode='linux';
$state=array(0,'OK');

function get_snmp($snmp_oid_get) {
    global $cpu, $snmp_auth, $snmp_version , $host ,$snmp_community , $debug_snmp ,$snmp_authprot, $snmp_user, $snmp_password, $snmp_privprot, $snmp_privpassword;
    if ( $snmp_version == '2' ) { 
      if ( $debug_snmp == true ) {
        $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid_get,1000000,5 );
        }
      else {
        $snmp=snmp2_get( $host , $snmp_community, $snmp_oid_get,1000000,5 );
        }
    }
    elseif ( $snmp_version == '3' ) {
      if ( $debug_snmp == true ) {
        $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get,1000000,5 );
        }
      else {
        $snmp=snmp3_get($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get,1000000,5 );
        }
     }
    if ( $snmp === false && $cpu == 0 ) {
      echo 'CRITICAL - no connection' . PHP_EOL;
      exit(2);
    } 
    eval('$snmp_get = $snmp;');
    return $snmp_get;
}

function get_string($snmp_oid_get) {
        $string=preg_split('/ /' , get_snmp($snmp_oid_get));
        array_shift($string);
        $string=rtrim(trim(implode(" ",$string),"\""));
        return "$string";
}

while ($arg <= $argc) {
        switch ( @$argv[$arg] ) {
                case '-H':
			$host=@$argv[$arg+1];
			break;
		case '-m':
			$mode=strtolower(@$argv[$arg+1]);
			break;
		case '-w':
			$warn=@$argv[$arg+1];
			break;
		case '-c':
			$crit=@$argv[$arg+1];
			break;
		case '-d':
			$arg=$arg - 1;
			$debug=true;
			break;
		case '-P':
			$snmp_version=@$argv[$arg+1];
                        if ( $snmp_version != '2' and $snmp_version != '3' )
                         { echo 'Error: -P [snmp Version], must be 2 or 3' . PHP_EOL; 
                           exit(0); }
			break;
		case '-C':
			$snmp_community=@$argv[$arg+1];
			break;
		case '-u':
			$snmp_user=@$argv[$arg+1];
			break;
		case '-p':
			$snmp_password=@$argv[$arg+1];
			break;
		case '-a':
			$snmp_authprot=@$argv[$arg+1];
                        $snmp_auth='authNoPriv';
                        if ( $snmp_authprot != 'MD5' and $snmp_authprot != 'SHA' )
                         { echo 'Error:  -a [auth. prot. (MD5/SHA] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-x':
			$snmp_privprot=@$argv[$arg+1];
                        $snmp_auth='authPriv';
                        if ( $snmp_privprot != 'DES' and $snmp_privprot != 'AES' )
                         { echo 'Error:  -x [priv. prot. (DES/AES] value is not correct!' . PHP_EOL;
                           exit(0); }
			break;
		case '-X':
			$snmp_privpassword=@$argv[$arg+1];
			break;
		case '-V':
			$arg=$arg - 1;
			$debug_snmp=true; 
			break;
		case '-h':
			$arg=$arg - 1;
                        $help=true;
			break;
	}
	$arg = $arg + 2;
}

if ( $debug === false ) {
  error_reporting(0); }
else {
  error_reporting(-1); }

if ( $help == true || $argc == 1 ) {
echo PHP_EOL;
echo 'Usage: /usr/bin/php check_cpu.php -H [host] -P [snmp_version] -m [mode] (-w [Warning] -c [Critical] -d (debug) -V (snmp debug))' . PHP_EOL;
echo PHP_EOL;
echo '        snmp_version - 2  -C [community string]  (default -C public)' . PHP_EOL;
echo '                       3  -u [user] -p [password] -a [auth. prot. (MD5/SHA] ( -x [priv. proto. (DES/AES)] -X [priv. password])'  . PHP_EOL;
echo PHP_EOL;
echo '        -m mode   - linux (default)' . PHP_EOL;
echo '                    windowsS' . PHP_EOL;
echo '                    load (Linux)' . PHP_EOL;
echo PHP_EOL;
echo 'Version: ' . $version . PHP_EOL;
echo 'Contact: nagios@jhoerter.com' . PHP_EOL;
echo PHP_EOL;
echo PHP_EOL;
exit(0);
}

switch ($mode) {
   case 'linux':
     $snmp_oid='1.3.6.1.4.1.2021.11';
     break;
   case 'load':
     $snmp_oid='.1.3.6.1.4.1.2021.10.1.3';
     break;
   case 'windows':
     $snmp_oid='.1.3.6.1.2.1.25.3.3.1.2';
     break;
   default:
     echo "Error, no correct mode" . PHP_EOL;
     exit(2);
}


if ( $debug_snmp == true ) { 
    $snmp_oid_get=$snmp_oid;
    print_r(get_snmp($snmp_oid_get));
    exit(0);
}


if ($mode == "linux" ) {
   $cpu_user=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.11.9.0'));
   $cpu_system=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.11.10.0'));
   $cpu_idle=preg_split('/ /' , get_snmp('1.3.6.1.4.1.2021.11.11.0'));
   $cpu_iowait=100 -  $cpu_system[1] - $cpu_user[1] - $cpu_idle[1];
   $cpu_total=$cpu_user[1] + $cpu_system[1];
   if ( $crit != "" ) {
        if ( intval($crit) < $cpu_total )
          { $state=array(2,'CRITICAL'); }
        elseif ( $warn != "" ) {
            if ( intval($warn) < $cpu_total)          
              { $state=array(1,'WARNING'); }
          }
      }

   echo $state[1] . " - " . $cpu_total . '% (User: ' . $cpu_user[1] . '% System: ' . $cpu_system[1] . '% I/O Wait: ' . $cpu_iowait . '% Idle: ' . $cpu_idle[1] . '%)|CPU=' . $cpu_total . '%;' . intval($warn). ';' . intval($crit) . ';; User=' . $cpu_user[1] . '% System=' . $cpu_system[1] . '% IOWait=' . $cpu_iowait . '% Idle=' . $cpu_idle[1] .'%' . PHP_EOL;
   exit($state[0]);
}
elseif ($mode == "windows" ) {
  if ($snmp_version == '2' ) {
    $snmp=snmp2_real_walk( $host , $snmp_community, $snmp_oid ); }
  else {
    $snmp=snmp3_real_walk($host,$snmp_user,$snmp_auth,$snmp_authprot,$snmp_password,$snmp_privprot,$snmp_privpassword,$snmp_oid_get );
  }
   if ( $snmp === false ) {
     echo 'CRITICAL - no connection' . PHP_EOL;
     exit(2); 
   }
   eval('$snmp_get = $snmp;');
   $snmp_get=array_values($snmp_get);
   $cpu=count($snmp_get);
   $count=0;
   $cpu_total=0;
   while( $count < $cpu) { 
     $cpu_get=preg_split('/ /', $snmp_get[$count]); 
     $cpu_total=$cpu_total + $cpu_get[1];       
     $count=$count+1;
   }
   $cpu_total=number_format($cpu_total/($count),2,".","");
   if ( $crit != "" ) {
      if ( intval($crit) < $cpu_total )
        { $state=array(2,'CRITICAL'); }
      elseif ( $warn != "" ) {
          if ( intval($warn) < $cpu_total)
            { $state=array(1,'WARNING'); }
        }
    }
   echo $state[1] . " - " . $cpu_total . '% | CPU=' . $cpu_total . '%;' . intval($warn). ';' . intval($crit) . ';0;100' . PHP_EOL;
   exit($state[0]);
}

elseif ($mode == "load") {
    $cpu_load1=get_string($snmp_oid . ".1");
    $cpu_load5=get_string($snmp_oid . ".2");
    $cpu_load15=get_string($snmp_oid . ".3");
    $warn=preg_split('/,/' ,$warn);
    $crit=preg_split('/,/',$crit);
    if ( $cpu_load1 >= $crit[0] or $cpu_load5 >= $crit[1] or $cpu_load15 >= $crit[2] ) {
       $status = 'CRITICAL';
       $status_code=2; }
    elseif ( $cpu_load1 >= $warn[0] or $cpu_load5 >= $warn[1] or $cpu_load15 >= $warn[2] ) {
       $status = 'WARNING';
       $status_code=1; }
    else {
       $status = 'OK';
       $status_code = 0; }
    echo $status . ' - load average: ' . $cpu_load1 . ', ' . $cpu_load5 . ', ' . $cpu_load15;
    echo ' | load1=' . $cpu_load1 . ';' . $warn[0] .';' . $crit[0] . ';; load5=' . $cpu_load5 . ';' . $warn[1] . ';' . $crit[1] .';; load15=' . $cpu_load15 . ';' . $warn[2] .';' . $crit[2] .';;  ' . PHP_EOL;
    exit(0);
} 
?>
